import java.io.*;

public class Terminal
{    
    public static String lireString() // Lire un String
    {
        String tmp="";
        try {
            tmp = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException e)
            {
                System.out.println("Erreur de lecture de chaine");
            }
        return tmp;
    }

    public static int lireInt()  // Lire un entier
    {
        int x=0;
        try {
            x=Integer.parseInt(lireString());
        }
        catch (NumberFormatException e) {
            System.out.println("Erreur de lecture d'un entier");
        }	
        return x ;
    }

    public  static double lireDouble()  // Lire un double
    {
        double x=0.0;
        try {
            x=Double.valueOf(lireString()).doubleValue();
        }
        catch (NumberFormatException e) {
            System.out.println("Erreur de lecture d'un double");
        }	
        return x ;
    }

    public  static char lireChar()  // Lire un caractere
    {
        String tmp=lireString();
        if (tmp.length()==0)
            return '\n';
        else 
            {
                return tmp.charAt(0);
            }
    }

    public static void ecrireString(String s) // Afficher un String
    {
        System.out.print(s);
    }

    public static void ecrireStringln(String s) // Afficher un String
    {
        ecrireString(s);
        sautDeLigne();
    } 

    public static void ecrireInt(int i)  // Afficher un entier
    {
        ecrireString(""+i);
    }

    public static void ecrireIntln(int i)  // Afficher un entier
    {
        ecrireString(""+i);
        sautDeLigne();
    }

    public static void ecrireBoolean(boolean b)  // Afficher un boolen
    {
        ecrireString(""+b);
    }

    public static void ecrireBooleanln(boolean b) // Afficher un boolen
    {
        ecrireString(""+b);
        sautDeLigne();
    }

    public  static void ecrireDouble(double d)  // Afficher un double
    {
        ecrireString(""+d);
    }

    public  static void ecrireDoubleln(double d)  // Afficher un double
    {
        ecrireDouble(d);
        sautDeLigne();
    }

    public  static void ecrireChar(char c)  // Afficher un caractere
    {
        ecrireString(""+c);
    }  

    public  static void ecrireCharln(char c)  // Afficher un caractere
    {
        ecrireChar(c);
        sautDeLigne();
    }

    public static void sautDeLigne()  // Sauter une ligne
    {
        System.out.println();
    }
}  

