// Exemples d'utilisation des classes String, StringBuffer 
//   et StringTokenizer
import java.io.*;
import java.util.*;

public class Exemple02
{
    public static void main(String a_args[])
    {
        String str1,str2,str3,str4;

        // ===================================================
        Terminal.ecrireStringln("La valeur constante de chaine de caractere ");
        Terminal.ecrireStringln("  est creee automatiquement par Java sous la ");
        Terminal.ecrireStringln("  forme d un objet String");

        // --------------------------------------------
        str1="Je suis une chaine litterale";
        // --------------------------------------------

        Terminal.ecrireStringln(str1);
        Terminal.ecrireStringln("Ceci est equivalent a:");

        // --------------------------------------------
        str1=new String("Je suis un objet String");
        // --------------------------------------------

        Terminal.ecrireStringln(str1);
    
        Terminal.ecrireStringln("");
        Terminal.ecrireString("Taper un rc pour continuer...");
        Terminal.lireString();
        // ====================================================
            
        Terminal.ecrireStringln("La concatenation de chaine est tres utilise pour creer de nouvelles");
        Terminal.ecrireStringln("  chaines de caracteres. La desallocation automatique des objets non ");
        Terminal.ecrireStringln("  references par Java facilite une telle utilisation");
        Terminal.ecrireStringln("La concatenation entre chaine peut se faire avec la mthode");
        Terminal.ecrireStringln("  'concat' mais on lui prefere largement l'oprateur '+' qui ralise");
        Terminal.ecrireStringln("  automatiquement les conversions necessaires en chaines de caracteres");
        Terminal.ecrireStringln("  des valeurs a concatener");

        // --------------------------------------------
        str1="La valeur du champ ";
        str2="PARAM1";
        str1=str1+str2; /* Remarquez la reutilisation de str1 */
        // --------------------------------------------

        Terminal.ecrireStringln(str1);
    
        Terminal.ecrireStringln(" ou");

        // --------------------------------------------
        str1="La valeur du champ ";
        str2="PARAM1";
        str2=str1.concat(str2);
        Terminal.ecrireStringln(str2);
        // --------------------------------------------

        Terminal.ecrireStringln("");
        Terminal.ecrireString("Taper un rc pour continuer...");
        Terminal.lireString();
        // ====================================================
    
        Terminal.ecrireStringln("  Concatenation de valeur heterogene");

        // --------------------------------------------
        int n=100;
        double d=3.1415;
        boolean b=true;
        str1="La valeur du champ ";
        str2="PARAM1";
        str1=str1+str2+" "+n+" "+d+" "+b+" FIN";
        // --------------------------------------------

        Terminal.ecrireStringln(str1); //La valeur du champ PARAM1 100 3.1415 true FIN
    
        Terminal.ecrireStringln("");
        Terminal.ecrireString("Taper un rc pour continuer...");
        Terminal.lireString();
        // ====================================================

        /* Ce n'est pas parceque l'on utilise la classe String que
           l'on ne peut pas "modifier" une chaine en creant une nouvelle.
           Exemple : remplacer u caractere par un autre */
        str1="/home/jl/bin";
        str2=str1.replace('/','\\');  // Il faut doubler le \ //
        Terminal.ecrireStringln(str2);
        Terminal.ecrireStringln(str1); // la chaine str1 n'a pas changee de valeur
        // sauf
        str1="/home/jl/bin";
        str1=str1.replace('/','\\');  // Il faut doubler le \ //
        Terminal.ecrireStringln(str1);
        // On ne change pas la valeur de str1 mais on cree une nouvelle
        // reference que l'on donne a str1. L'ancienne reference est perdue.

        // Comment convertir un entier en chaine de caractere
        // 1
        Integer ObjInt;
        ObjInt=new Integer(100);
        str1=ObjInt.toString();   // Tous les objets JAVA possede la mthode toString
        Terminal.ecrireStringln(str1);
        // 2
        str1=""+1000; // On concatene artificiellement la chaine vide a l'entier
        Terminal.ecrireStringln(str1);
        // 3
        n=10000;
        str1=String.valueOf(n); // Methode static de la classe String
        // Cette methode existe pour les type double float boolean int long
        Terminal.ecrireStringln(str1);

        //Comment convertir une chaine de caractere en entier
        str1="12345";
        Integer oi=new Integer(str1); // en utilisant le constructeur de Integer
        Terminal.ecrireStringln(oi.toString());
        n=oi.intValue(); // pour convertir de Integer en int
        Terminal.ecrireStringln(""+n);

        //Les fonctions les plus usuelles
        //
        //Test l'galit
        str1="toto";
        str2="toto";
        if (str1==str2) Terminal.ecrireStringln("EGALE"); //EGALE
        else Terminal.ecrireStringln("NON EGALE");
        if (str1.equals(str2)) 
            Terminal.ecrireStringln("EGALE");  //EGALE
        else Terminal.ecrireStringln("NON EGALE");

        str1=new String("toto");
        str2=new String("toto");
        if (str1==str2) 
            Terminal.ecrireStringln("EGALE");         //NON EGALE
        else Terminal.ecrireStringln("NON EGALE");
        if (str1.equals(str2)) 
            Terminal.ecrireStringln("EGALE");  //EGALE
        else Terminal.ecrireStringln("NON EGALE");

        //Comparaison sans distinction des majuscules et des minuscules
        str1=new String("toto$%");
        str2=new String("TotO$%");
        if (str1.equalsIgnoreCase(str2)) 
            Terminal.ecrireStringln("EGALE");  //EGALE
        else Terminal.ecrireStringln("NON EGALE");

        //Comparaison
        str1="LAFONT";
        str2="DUPONT";
        n=str1.compareTo(str2);
        if (n==0) Terminal.ecrireStringln("str1=str2");
        else if (n>0) Terminal.ecrireStringln("str1>str2");
        else Terminal.ecrireStringln("str1<str2");

        str2="LAFONT";
        str1="DUPONT";
        n=str1.compareTo(str2);
        if (n==0) Terminal.ecrireStringln("str1=str2");
        else if (n>0) Terminal.ecrireStringln("str1>str2");
        else Terminal.ecrireStringln("str1<str2");

        str1="LAFONT";
        str2="LAFONT";
        n=str1.compareTo(str2);
        if (n==0) Terminal.ecrireStringln("str1=str2");
        else if (n>0) Terminal.ecrireStringln("str1>str2");
        else Terminal.ecrireStringln("str1<str2");
    
    
        //Extraction des caractres
        int i;
        str1="ABCD";
        for(i=0;i<str1.length();i++)
            Terminal.ecrireStringln(""+str1.charAt(i));

        //--------   split
        Terminal.ecrireStringln("split sans limit");
        str1 = "toto;tata;titi";
        String[] ts = str1.split(";");
        for(String s:ts) Terminal.ecrireStringln("->"+s);
        Terminal.ecrireStringln("-----");

        Terminal.ecrireStringln("split avec limit");
        str1 = "toto;tata;titi;;tutu;;;;";
        ts = str1.split(";",11);
        for(String s:ts) Terminal.ecrireStringln("->"+s);
        Terminal.ecrireStringln("-----");



        /* =================== STRINGBUFFER======================= */
        StringBuffer Str1,Str2,Str3;

        Str1=new StringBuffer("Ceci est un exemple");
        Terminal.ecrireStringln(Str1.toString());
        Str1.append(" : ");
        Str1.append(123);
        Str1.append(1.45);
        Str1.append(true);
        Terminal.ecrireStringln(Str1.toString()); 
        //Ceci est un exemple : 1231.45true
    
        Str1=new StringBuffer("Ceci est un exemple");
        Terminal.ecrireStringln(Str1.toString());
        Str1.append(" : ");
        Str1.append(" "+123);
        Str1.append(" "+1.45);
        Str1.append(" "+true);
        Terminal.ecrireStringln(Str1.toString()); 
        //Ceci est un exemple : 123 1.45 true
    
        n=Str1.length();
        Terminal.ecrireStringln("Longueur de Str1: "+n); //36

        Str1.setLength(40);
        n=Str1.length();
        Terminal.ecrireStringln("Longueur de Str1: "+n); //40
        Terminal.ecrireStringln(Str1.toString()+"$"); 
        //Ceci est un exemple : 123 1.45 true    $

        Str1.setLength(10);
        n=Str1.length();
        Terminal.ecrireStringln("Longueur de Str1: "+n); //19
        Terminal.ecrireStringln(Str1.toString()); //Ceci est u

        // Insertion de "user/" avant jl
        Str1 = new StringBuffer("/home/jl/bin");
        n=Str1.toString().indexOf("jl");
        if (n!=-1) Str1.insert(n,"user/");
        Terminal.ecrireStringln(Str1.toString()); // /home/user/jl/bin

        // Les fonctions append et insert s'utilise avec tous les
        // types primitifs

        /* ============ STRINGTOKENIZER =========================== */

        StringTokenizer Strtok1 = new StringTokenizer("  Ceci  est un   exmple   ");

        while (Strtok1.hasMoreTokens())
            {
                String s = Strtok1.nextToken();
                Terminal.ecrireStringln(s);
            }


        Strtok1 = new StringTokenizer("/home/user/jl/fichier","/");

        while (Strtok1.hasMoreTokens())
            {
                String s = Strtok1.nextToken();
                Terminal.ecrireStringln("->"+s);
            }

        Terminal.ecrireString("Taper un rc pour continuer...");
        Terminal.lireString();
    }
}
