// Calcul de l'quation du second degr en utilisant un Terminal
public class Exemple03a
{
    public static void main(String a_args[])
    {
        
        Terminal.ecrireStringln("Resolution d'une quation du 2 degr");

        double a,b,c;

        while (true)
            {
                // Saisie des coefficients
                //
                Terminal.ecrireString("Saisir a : ");
                a = Terminal.lireDouble();
                Terminal.ecrireString("Saisir b : ");
                b = Terminal.lireDouble();
                Terminal.ecrireString("Saisir c : ");
                c = Terminal.lireDouble();

                // Creation de l'objet qui contient la methode
                //  de resolution
                Equ2Degre equ = new Equ2Degre();

                // Resolution de l'equation
                equ.resoudre(a,b,c);   // Le resultat est dans l'objet equ
                
                // Afficage du resultat
                //
                if (equ.erreur != null)
                    Terminal.ecrireStringln(equ.erreur);
                else
                    {
                        Terminal.ecrireStringln("Solutions : " + equ.x1 + " " + equ.x2);
                        
                        // On verifie que le calcul de resolution est correct
                        //  en injectant les solutions dans l'equation
                        //
                        Terminal.ecrireStringln("Verification:");
                        double y1,y2;
                        y1 = a * equ.x1 * equ.x1 + b * equ.x1 + c;
                        y2 = a * equ.x2 * equ.x2 + b * equ.x2 + c;
                        Terminal.ecrireStringln("y1 = " + y1);
                        Terminal.ecrireStringln("y2 = " + y2);
                    }
            }
    }
}

// Classe qui contient le calcul de resolution d'une equation du 2er degre
//
class Equ2Degre
{
    public String erreur;  // non null si erreur de resolution
    public double x1;      // solution 1 de l'equation
    public double x2;      // solution 2 de l'equation
    
    // Methode de resolution qui prend en entree les coefficients.
    //  Les resultats sont memorises dans les attributs de l'objet
    //
    public void resoudre(double a,double b,double c)
    {
        // Initialisation des resultats
        erreur = null;
        x1 = 0.0;
        x2 = 0.0;

        // Resolution
        //
        double delta;

        if (a==0)
            erreur = "Erreur : a = 0";
        else
            {
                delta = (b*b) - (4*a*c);
                if (delta<0)
                    erreur = "delta < 0";
                else
                    if (delta == 0)
                        x2 = x1 = ( -b ) / (2*a);
                    else
                        {
                            x1 = (-b + Math.sqrt(delta))/(2*a);
                            x2 = (-b - Math.sqrt(delta))/(2*a);
                        }
            }
    }
}
