// Calcul de l'quation du second degr en utilisant un formulaire
import fr.cnam.ihm.*;

public class Exemple03b implements FormulaireInt
{
    public static void main(String[] args)
    {
        Exemple03b ex = new Exemple03b();
        
        Formulaire form = new Formulaire("EQUATION 2 DEGRE",ex,500,200);
        form.addLabel("Resolution d'une equation du second degre :");
        form.addText("COEFF_A","Coefficient A",true,"");
        form.addText("COEFF_B","Coefficient B",true,"");
        form.addText("COEFF_C","Coefficient C",true,"");
        form.addButton("RESOUDRE","Resoudre");
        form.addText("RESULTAT","Resultat",false,"");
        form.afficher();
    }

    public void submit(Formulaire form,String nomSubmit)
    {
        if (nomSubmit.equals("RESOUDRE"))
            {
                double a = Double.parseDouble(form.getValeurChamp("COEFF_A"));
                double b = Double.parseDouble(form.getValeurChamp("COEFF_B"));
                double c = Double.parseDouble(form.getValeurChamp("COEFF_C"));

                Equ2Degre equ = new Equ2Degre();
                equ.resoudre(a,b,c);
                
                if (equ.erreur != null)
                    form.setValeurChamp("RESULTAT",equ.erreur);
                else
                    {
                        form.setValeurChamp("RESULTAT",
                                            String.format("%.2f %.2f",equ.x1,equ.x2));
                    }
            }
    }
}

class Equ2Degre
{
    public String erreur;  // = null par defaut
    public double x1;     
    public double x2;
    
    public void resoudre(double a,double b,double c)
    {
        erreur = null;
        x1 = 0.0;
        x2 = 0.0;

        double delta;

        if (a==0)
            erreur = "Erreur : a = 0";
        else
            {
                delta = (b*b) - (4*a*c);
                if (delta<0)
                    erreur = "delta < 0";
                else
                    if (delta == 0)
                        x2 = x1 = ( -b ) / (2*a);
                    else
                        {
                            x1 = (-b + Math.sqrt(delta))/(2*a);
                            x2 = (-b - Math.sqrt(delta))/(2*a);
                        }
            }
    }
}
