// Calcul de l'quation du second degr en utilisant un formulaire et une zone de resultat qui sert d'historique
import fr.cnam.ihm.*;

public class Exemple03c implements FormulaireInt
{
    private String resultat; // la zone de resultat

    public Exemple03c()
    {
        resultat = "";
    }

    public static void main(String[] args)
    {
        Exemple03c ex = new Exemple03c();
        
        Formulaire form = new Formulaire("EQUATION 2 DEGRE",ex,700,400);
        form.addText("COEFF_A","Coefficient A",true,"");
        form.addText("COEFF_B","Coefficient B",true,"");
        form.addText("COEFF_C","Coefficient C",true,"");
        form.addButton("RESOUDRE","Resoudre");
        form.setPosition(300,0);
        form.addZoneText("RESULTAT",
                         "Resultat",
                         false,
                         "",
                         300,
                         400);
        form.afficher();
    }

    public void submit(Formulaire form,String nomSubmit)
    {
        if (nomSubmit.equals("RESOUDRE"))
            {
                String strA = form.getValeurChamp("COEFF_A");
                String strB = form.getValeurChamp("COEFF_B");
                String strC = form.getValeurChamp("COEFF_C");
                if ( (strA.equals("")) || (strB.equals("")) || (strB.equals("")) )
                    {
                        resultat = resultat + String.format("\nZone de saisie vide\n");
                        form.setValeurChamp("RESULTAT",resultat);
                        return;
                    }

                double a = Double.parseDouble(strA);
                double b = Double.parseDouble(strB);
                double c = Double.parseDouble(strC);
                resultat = resultat + 
                    String.format("\nResolution de : %.2f %.2f %.2f\n",a,b,c);
                                  

                Equ2Degre equ = new Equ2Degre();
                equ.resoudre(a,b,c);
                resultat = resultat + "Resultat : ";

                if (equ.erreur != null)
                    {
                        resultat = resultat + equ.erreur + "\n";
                        form.setValeurChamp("RESULTAT",resultat);
                    }
                else
                    {
                        resultat = resultat + String.format("%.2f %.2f",equ.x1,equ.x2) + "\n";
                        form.setValeurChamp("RESULTAT",resultat);
                    }
            }
    }
}

class Equ2Degre
{
    public String erreur;  // = null par defaut
    public double x1;     
    public double x2;
    
    public void resoudre(double a,double b,double c)
    {
        erreur = null;
        x1 = 0.0;
        x2 = 0.0;

        double delta;

        if (a==0)
            erreur = "Erreur : a = 0";
        else
            {
                delta = (b*b) - (4*a*c);
                if (delta<0)
                    erreur = "delta < 0";
                else
                    if (delta == 0)
                        x2 = x1 = ( -b ) / (2*a);
                    else
                        {
                            x1 = (-b + Math.sqrt(delta))/(2*a);
                            x2 = (-b - Math.sqrt(delta))/(2*a);
                        }
            }
    }
}
