package fr.cnam.ihm;

/**
   Adaptater d'implmentation par defaut de l'interface utilise par le constructeur de CanvasHM permettant de traiter les clics dans la grille et dans le canvas
 */
public class AdaptaterControlesCanvasIHM implements ControlesCanvasIHM
{
    /** 
        Methode appellee quand la grille est affichee et quand on clique dans une des cases de la grille
        @param xCase coordonnee en X de la case dans la grille
        @param yCase coordonnee en Y de la case dans la grille
        @param ihm l'instance de la CanvasIHM. Permet d'utiliser les mthodes publiques de CanvasIHM dans l'action.
    */
    public void pointerCaseGrille(int xCase,int yCase,CanvasIHM ihm)
    {
        System.out.println("pointerCaseGrille: "+xCase+" "+yCase);
    }

    /**
       Methode appellee quand la grille n'est pas affichee et quand on clique dans le canvas.
       @param x corrdonee en pixel X de la position de la souris
       @param y corrdonee en pixel Y de la position de la souris
       @param ihm l'instance de la CanvasIHM. Permet d'utiliser les mthodes publiques de CanvasIHM dans l'action.
    */
    public void pointerCanvas(int x,int y,CanvasIHM ihm)
    {
        System.out.println("pointerCanvas: "+x+" "+y);
    }
    
}
