// Classe de definition d'un livre
//
public class Livre
{
  private String      ident;      // Identification unique du livre
  private String      titre;      // Titre du livre
  private String      sousTitre;  // Sous-titre du livre
  private String[]    auteurs;    // Les auteurs du livre
  private int         tome;       // Tome du livre (0 si pas plusieurs tome)
  private GenreLivre  genre;      // Genre du livre

  // Constructeur 
  //
  public Livre(String ident,
               String titre,String sousTitre,
               String[] auteurs,
               int tome,
               GenreLivre genre)
  {
    this.ident     = ident;
    this.titre     = titre;
    this.sousTitre = sousTitre;
    this.auteurs   = auteurs;
    this.tome      = tome;
    this.genre     = genre;
  }

  // Afficher le titre et/ou sous-titre d'un livre
  //
  public void afficherTitre()
  {
    if (! sousTitre.equals(""))
      {
        Terminal.ecrireStringln(titre + "(" + sousTitre + ")" );
        return;
      }
    Terminal.ecrireStringln(titre);
  }

  // Conversion d'un livre en chain
  //
  public String toString()
  {
    String str="";
    str=str+"Ident       : "+ident+"\n";
    str=str+"Titre       : "+titre+"\n";
    str=str+"Sous-titre  : "+sousTitre+"\n";
    str=str+"Tome        : "+tome+"\n";
    str=str+"Auteurs     : ";
    for(String s:auteurs) str=str+s+"   ";
    str=str+"\n";
    str=str+"genre       : "+genre+"\n";
    return ( str );
  }

  // Methode static pour afficher plusieurs livres
  //
  static public void afficherLivres(Livre... livres)
  {
    for(Livre l:livres)
      Terminal.ecrireStringln( l.toString() );
  }

  // getteurs
  //
  public int getTome(){return tome;}
  public String[] getAuteurs(){return auteurs;}
  public GenreLivre getGenre(){return genre;}
    
  // setteurs
  //
  public void setIdent(String a_ident){ident = a_ident;}
  public void setTome(int a_tome){tome = a_tome;}
  public void setTitre(String a_titre){titre = a_titre;}
  public void setTitre(String a_titre,String a_sousTitre)
  {
    titre = a_titre;
    sousTitre = a_sousTitre;
  }
  public void setAuteurs(String[] a_auteurs){auteurs = a_auteurs;}

}
