// Exemple de creation d'une classe qui gere un arbre binaire
//   - d'entier
//   - d'expression arithmetique
//
public class Exemple11
{
    // Programme principal
    //
    public static void main(String... args)
    {
        System.out.println("Execution de Exemple11");

        // Creation d'un arbre d'entier
        //
        Arbre n1 = new Arbre(new Integer(10));
        Arbre n2 = n1.addGauche(5);
        Arbre n3 = n1.addDroit(21);
        Arbre n4 = n2.addGauche(1);
        Arbre n5 = n2.addDroit(7);
        Arbre n6 = n3.addGauche(13);

        // Creation d'un autre arbre d'entier
        Arbre r1 = new Arbre(new Integer(100));
        Arbre r2 = r1.addDroit(200);
        r2.addGauche(300);
        r2.addDroit(400);

        // Ajout du 2eme arbre a un noeud du 1er
        //
        n3.setDroit(r1);

        // Affichages de l'arbre

        n1.afficher();
        System.out.println("---------------");

        n1.afficherPrefixe();
        System.out.println("---------------");

        n1.afficherSuffixe();
        System.out.println("---------------");



        // Creation d'un arbre d'expression arithmetique
        //
        Arbre e1 = new Arbre("*",
                             new Arbre("+",3.5,5.5),
                             new Arbre("/",10.0,20.0));
        e1.afficher();  

        // Resultat : 75.0
        System.out.println("Resultat: "+calculer(e1));

    }

    // Methode qui calcule une expression arithmetique
    //
    private static double calculer(Arbre a)
    {
        if (a.siFeuille()) return (double)(a.getValue());
        else
            {
                if (a.getValue().equals("*"))
                    return calculer(a.getGauche())*calculer(a.getDroit());
                if (a.getValue().equals("+"))
                    return calculer(a.getGauche())+calculer(a.getDroit());
                if (a.getValue().equals("/"))
                    return calculer(a.getGauche())/calculer(a.getDroit());
                return(0);
            }
    }
}