import java.util.*;

// Classe de definition d'un arbre qui permet de gérer
//  un arbre n-aire
//
public class Arbre
{
    private Object value;            // Valeur du noeud
    private ArrayList<Arbre> fils;   // Les sous-arbres
    
    // Constructeurs
    //
    public Arbre(Object value)
    {
        this.value = value;
        fils = new ArrayList<Arbre>();
    }
    //
    public Arbre(Object value,Object... valeurs)
    {
        this.value = value;
        fils = new ArrayList<Arbre>();
        for(Object o:valeurs) fils.add(new Arbre(o));
    }
    //
    public Arbre(Object value,Arbre... arbres)
    {
        this.value = value;
        fils = new ArrayList<Arbre>();
        for(Arbre a:arbres) fils.add(a);
    }
    
    // Retourne la valeur du noeud
    //
    public Object getValue()
    {
        return(value);
    }

    // Teste si un noeud est une feuille
    public boolean siFeuille()
    {
        return (fils.size()==0);
    }

    // Retourne la marche de n caract blancs
    //  (utilise pour afficher les arbres)
    //
    static private String marge(int m)
    {
        String s="";
        for(int i=0;i<m;i++)s=s+" ";
        return s;
    }

    // Ajoute un fils a un arbre n-aire
    //
    public Arbre ajouterFils(Object value)
    {
        Arbre a = new Arbre(value);
        fils.add(a);
        return a;
    }

    // Affiche un arbre n-aire 
    public void afficher()
    {
        afficherRec(this,0);
    }
    static private void afficherRec(Arbre arbre,int n)
    {
        System.out.println(marge(n)+arbre.getValue());
        for(Arbre a:arbre.fils)
            afficherRec(a,n+3);
    }
        
}
