// Exemple de la creation d'un type enum et son utilisation
//
public class Exemple36
{
    public static void main(String... a_args)
    {
        Terminal.ecrireStringln("Enum");

        Jours unJour;

        // unJour = Lundi;      // pas correct
        unJour = Jours.Lundi;   // correct : il faut toujours 
        // acceder a une enumeration par sa classe (acces static)


        // String jourStr = Jours.Lundi  // Pas correct
        // Le type enum n'est pas une chaine de caractere
        
        // Conversion explicite en chaine
        String jourStr = Jours.Lundi.toString();
        Terminal.ecrireStringln("unJour = " + jourStr);

        // Conversion implicite en chaine
        Terminal.ecrireStringln("unJour = " + unJour);

        // L'operateur == permet de tester l'égalité d'un enum
        if (unJour == Jours.Lundi)
            Terminal.ecrireStringln("C'est lundi!!");
        // La valeur enum est en fait un entier : methode ordinal()
        int numJour = unJour.ordinal();
        Terminal.ecrireStringln("numJour = " + numJour);

        // On peut parcourir les valeurs d'un enum avec la methode values()
        for(Jours j : Jours.values())
            Terminal.ecrireStringln("" + j +  "-> " + j.ordinal());
        
        // Une classe qui utilise un enum
        Exemple ex = new Exemple();

        if (ex.j == null)
            Terminal.ecrireStringln("ex.j est null par defaut");

    }
}

enum Jours
{
    Lundi,
    Mardi,
    Mercredi,
    Jeudi,
    Vendredi,
    Samedi,
    Dimanche
}

class Exemple
{
    Jours j;
}

