// Exemple de code d'utilisation de la classe Calendar
//
import java.util.*;
import java.text.*;

public class Exemple40
{
    static public void main(String[] args)
    {

        // Retourne la date courante 
        // Une date calendar contient les heures minutes secondes et 
        //   millisecondes du temps courant => Attention au comparaison de dates
        //
        Calendar date = Calendar.getInstance();
        System.out.println(date.toString());
        // Pas si illisible que cela mais affiche toutes les informations
        
        Date d = date.getTime();
        System.out.println(d.toString());
        // Plus lisible car Date ne contientque les informations essentielles
        // Sun Dec 14 17:19:19 CET 2014

        //Si on veut créer une date en fonction des informations 
        //  entières de date et heure
        //  Exemple pour    28/11/2014 12h35
        //
        date = Calendar.getInstance();
        date.clear();
        date.set(2014,11,28,12,35,0);
        System.out.println(">> "+date.getTime());
        // Sun Dec 28 12:35:00 CET 2014


        // Pour montrer que deux dates calendar obtenus dans un programme ne
        //  sont pas égales
        date = Calendar.getInstance();
        Terminal.ecrireString("tapez une touche...");
        Terminal.lireString();  // Pour mettre un peu de temps entre la creation
        // des deux dates
        Calendar date2 = Calendar.getInstance();
        if (date.equals(date2)) System.out.println("EGALES");  // PAS EGALES
        else System.out.println("PAS EGALES");

        // Si on veut récupérer la date courante et la comparer avec 
        // des dates qui n'ont pas de heures minutes secondes et millisecondes
        // il faut enleber les infos heures minutes secondes et millisecondes
        date = Calendar.getInstance();
        Terminal.ecrireString("tapez une touche...");
        Terminal.lireString();  
        date2 = Calendar.getInstance();
        date.clear(Calendar.HOUR);
        date.clear(Calendar.MINUTE);
        date.clear(Calendar.SECOND);
        date.clear(Calendar.MILLISECOND);
        date2.clear(Calendar.HOUR);
        date2.clear(Calendar.MINUTE);
        date2.clear(Calendar.SECOND);
        date2.clear(Calendar.MILLISECOND);
        System.out.println("date>> "+date2.getTime());
        System.out.println("date2>> "+date2.getTime());
        if (date.equals(date2)) System.out.println("EGALES");  // EGALES
        else System.out.println("PAS EGALES");


        //Si on gère une date en jour mois annee heure et minute
        // et que l'on veut savoir si cette date est égale à une date d'un jour
        // On utilise un clone pour ne pas altéré la date initiale.
        // 
        // date2 est une date de jour (actuelle)
        //
        date = Calendar.getInstance();
        Calendar dateJour = (Calendar)date.clone();  // clone 
        dateJour.clear(Calendar.HOUR);
        dateJour.clear(Calendar.MINUTE);
        dateJour.clear(Calendar.SECOND);
        dateJour.clear(Calendar.MILLISECOND);
        System.out.println("date2>> "+date2.getTime());
        System.out.println("dateJour>> "+date2.getTime());
        if (date2.equals(dateJour)) System.out.println("EGALES");  // EGALES
        else System.out.println("PAS EGALES");
        

        //A partir d'une chaine au format "JJ/MM/AAAA HH:MM"
        // Utilisation de la classe SimpleDateFormat qui est dans le package java.text
        //
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        Date d1 = sdf.parse("28/11/2014 12:35",new ParsePosition(0));
        System.out.println("sdf to d1>> "+d1);
        // Fri Nov 28 12:35:00 CET 2014
        // La Date d1 créée a été créée avec la classe Calendar
        //
        // Pour passer de Date à Calendar
        Calendar cald1 = Calendar.getInstance();
        cald1.setTime(d1);


        // La valeur d'une date en millisecondes ( depuis 1 Janvier 1970)
        //
        long time = date.getTimeInMillis();
        System.out.println("Time : "+time);


        // Pour le projet sur les rendez-vous il est conseillé quand
        // on crée un rendez-vous on initialise deux attributs:
        //   Calendar dateHeure;      qui est la date en jour, mois, annee, heure et minute du rendez-vous
        //   Calendar dateJour;       qui est la date en jour, mois et annee du rendez-vous
        //
        // L'attribut dateHeure permet d'ordonner chronologiquement les rendez-vous
        //
        // L'attribut dateJour permet de déterminer les rendez-vous qui appartiennnent à un jour donné
        //


    }
}

