/**
   Classe de dfinition d'une phrase.<br>
   Une phrase est avant tout une chane de caractres dont les mots sont espacs par des caractres blancs.
*/
public class Phrase
{
    private String phrase; // La String contenant la phrase

    /** Ce constructeur cre une phrase dont la valeur par dfaut est "". */
    public Phrase()
    {
        this.phrase = new String("");
    }

    /** Ce constructeur cre une phrase dont la valeur est la String pass en paramtre.
       @param phrase : la chaine */
    public Phrase(String phrase)
    {
        this.phrase = phrase;
    }
    
    /** retourne la chaine de la phrase 
     @return String */
    public String toString(){return phrase;}

    /** mthode qui modifie la phrase
        @param p : la phrase */
    public void setPhrase(String p){phrase=p;}

    /** mthode qui permet de saisir en console la phrase 
     @param texteInvite : texte affich avant la demande de saisie*/
    public void saisir(String texteInvite)
    {
        Terminal.ecrireString(texteInvite+" : ");
        this.phrase = Terminal.lireString();
    }
    
    /** mthode qui teste si la phrase est un palindrome.
        Algorithme : teste si la chaine et l'inversion de la chaine sont gales
        @return true ou flase suivant que la phrase est ou non un palindrome */
    public boolean palindrome1()
		{
        String l_chaine;
        l_chaine = this.phrase;

        String l_strtmp="";
        // Inversion de la chaine
        for(int i=0;i<l_chaine.length();i++)
            l_strtmp = l_chaine.charAt(i) + l_strtmp;
        
        if (l_strtmp.equals(l_chaine)) return true;
        else return false;
		}

    /** mthode qui teste si la phrase est un palindrome.
        Algorithme : parcours si les caractres sont en miroir
        @return true ou flase suivant que la phrase est ou non un palindrome */
    public boolean palindrome2()
		{
        String l_chaine;
        l_chaine = this.phrase;

        boolean l_palindrome = true;
        for(int i=0;i<l_chaine.length()/2;i++)
            if (l_chaine.charAt(i)!=l_chaine.charAt(l_chaine.length()-i-1))
                l_palindrome = false;

        if (l_palindrome) return true;
        else return false;
		}

    /**
       Cette mthode enlve les blans superflus de la phrase.<br>
       Exemple : la phrase "   je     suis     dans   la    cuisine   " <br>
       devient "je suis dans la cuisine" */
    public void diminuerBlancs()
    {
        // L'algorithme consiste  parcourir la phrase caractre par caractre
        //  et  ne garder que les caractres blancs qui sont suivis d'un
        //  caractre non blanc sauf pour ceux en dbut de phrase
        //
        String str="";
        int debut=-1;
        // on saute les ventuels premiers caracteres blancs
        for(int i=0;i<phrase.length();i++)
            if (phrase.charAt(i)!=' ')
                {
                    debut=i;
                    break;
                }
        if (debut==-1) 
            {
                phrase="";
                return;
            }

        for(int i=debut;i<phrase.length()-1;i++)
            {
                char car1 = phrase.charAt(i);
                char car2 = phrase.charAt(i+1);
                if (car1!=' ')
                    str=str+car1;
                else
                    if (car2!=' ')
                        str=str+car1;
            }
        if (phrase.charAt(phrase.length()-1)!=' ')
            str=str+phrase.charAt(phrase.length()-1);
        
        phrase=str;
    }

    /**
       Cette mthode enlve les blans superflus de la phrase.<br>
       Avec un algo  diffrent.
       Exemple : la phrase "   je     suis     dans   la    cuisine   " <br>
       devienr "je suis dans la cuisine" */
    public void diminuerBlancsBis()
    {
        // L'algorithme consiste  parcourir la phrase caractre par caractre,  compter
        //  les blanc et  ne mettre que si compteur = 1. On re initialise le compteur
        //  quand on tombe sur un caractere non blanc. Il reste ensuite ventuellement
        // 1 caract blanc en dbut ou 1 caract blanc  la fin qu'il faut lminier.
        //
        String str="";
        //
        int c=0;
        for(int i=0;i<phrase.length();i++)
            {
                if (phrase.charAt(i)!=' ')
                    {
                        str=str+phrase.charAt(i);
                        c = 0;
                    }
                else
                    {
                        c=c+1;
                        if (c==1)
                            str=str+' ';
                    }
            }
        phrase=str;

        // Enlever le caract blanc de debut et de la fin si il y en a
        str="";
        for(int i=0;i<phrase.length();i++)
            {
                if ( (i==0) && (phrase.charAt(i)==' '))
                    {}
                else if ( (i==phrase.length()-1) && (phrase.charAt(i)==' '))
                    {}
                else str=str+phrase.charAt(i);
            }
        phrase=str;
    }

    /**
       Cette mthode retourne un tableau contenant les mots de la phrase */
    public String[] isolerMots()
    {
        String[] tab = null;

        // On enlve les blancs superflus de la phrase
        diminuerBlancs();

        // Il suffirait de faire l'instruction suivante car la mthode prdfinie split existe
        //
        // return phrase.split(" ");
        //
        // Mais on peut faire l'algorithme suivant :
        //

        if (phrase.length()!=0)
        {
            // Soit pos la position courante de dbut d'un mot dans la phrase, le pos suivant
            // est le caractre qui suit le prochain caractere blanc
            
            boolean fini = false;
            int pos = 0;
            int debut, fin = 0;
            do {
                // Recherche du pos suivant et des indices de debut et fin du mot
                debut=pos;
                fin=-1;
                for(int i=pos;i<=phrase.length()-1;i++)
                    {
                        if (phrase.charAt(i)==' ')
                            {
                                fin   = i-1;
                                pos   = i+1;
                                break;
                            }
                    }
                //Si dernier mot
                if(fin==-1) 
                    {
                        fin=phrase.length()-1;
                        fini=true;
                    }
                
                // On extrait le mot de la phrase
                String mot = phrase.substring(debut,fin+1);
                
                // On ajoute le mot dans le trableau
                if (tab==null)
                    {
                        tab = new String[1];
                        tab[0] = mot;
                    }
                else
                    {
                        String[] tabTmp = new String[tab.length+1];
                        for(int i=0;i<tab.length;i++) tabTmp[i]=tab[i];
                        tabTmp[tabTmp.length-1]=mot;
                        tab=tabTmp;
                    }
            }while(! fini);
        }
        return tab;
    }
}
