
public class Media
{
    /** Identification du media. Cet identificateur est unique pour chaque mdia.
        
    */
    private String ident;

    /** Catgorie d'appartenance du mdia (ex: LIVRE, DVD, ...).
        Cette catgorie permet de faciliter le choix de mdia. */
    private String categorie;

    /** SousCatgorie d'appartenance du mdia. Cette information peuttre vide.
        (ex: pour les LIVRE : ROMAN, BIBLIO, SCIENCE. Pour les DVD : FILM, SERIE, REPORTAGE, ...)
        Cette catgorie permet de faciliter le choix de mdia. */
    private String sousCategorie;

    /** Tout mdia a une description courte permettant de savoir ce que c'est.
        Cette description est une chane courte. */
    private String description;

    /** si diffrent de null, le numero d'inscrption de l'emprunteur */
    private int emprunteur;

    /** La date d'emprunt */
    private String dateEmprunt;

    //=======================================================================
    // Constructeur d'un media
    public Media(String ident,
                 String categorie,
                 String sousCategorie,
                 String description)
                 
    {
        this.ident         = ident;
        this.categorie     = categorie;
        this.sousCategorie = sousCategorie;
        this.description   = description;
        this.emprunteur    = 0;
        this.dateEmprunt   = null;
    }

    //=======================================================================
    // Le media sous forme de chaine
    public String toString()
    {
        return
            this.ident         + "\n" +
            this.categorie     + "\n" +
            this.sousCategorie + "\n" +
            this.description   + "\n" +
            this.emprunteur;
    }
}

