
public class Media
{
    /** Identification du media. Cet identificateur est unique pour chaque mdia.
        La nomenclature est : AAAA-MM-NNNNN o AAAA est l'anne, MM est le mois et NNNNN est un numro qui est incrment  chaque cration du mdia
        Exemple : 2012-01-00012
    */
    private String ident;

    /** Catgorie d'appartenance du mdia (ex: LIVRE, DVD, ...).
        Cette catgorie permet de faciliter le choix de mdia. */
    private String categorie;

    /** SousCatgorie d'appartenance du mdia. Cette information peuttre vide.
        (ex: pour les LIVRE : ROMAN, BIBLIO, SCIENCE. Pour les DVD : FILM, SERIE, REPORTAGE, ...)
        Cette catgorie permet de faciliter le choix de mdia. */
    private String sousCategorie;

    /** Tout mdia a une description courte permettant de savoir ce que c'est.
        Cette description est une chane courte. */
    private String description;

    /** si diffrent de 0, le numero d'inscription de l'emprunteur */
    private int emprunteur;

    /** La date d'emprunt */
    private String dateEmprunt;

    //=======================================================================
    // Constructeur d'un media
    public Media(String ident,
                 String categorie,
                 String sousCategorie,
                 String description)
                 
    {
        this.ident         = ident;
        this.categorie     = categorie;
        this.sousCategorie = sousCategorie;
        this.description   = description;
        this.emprunteur    = 0;
        this.dateEmprunt   = null;
    }

    //=======================================================================
    // Constructeur d'un mdia (Ce constructeur est utilis pour rechercher
    //  un mdia en fonciton de son identificateur
    //
    public Media(String ident)
    {
        this.ident = ident;
    }

    //=======================================================================
    public String getCategorie(){return categorie;}
    public String getSousCategorie(){return sousCategorie;}
    public String getDescription(){return description;}
    public void   setEmprunteur(int numero){this.emprunteur=numero;}
    public void   setDateEmprunt(String date){this.dateEmprunt=date;}

    //=======================================================================
    // Media sous forme de chaine
    //
    public String toString()
    {
        return
            this.ident         + "\n" +
            this.categorie     + "\n" +
            this.sousCategorie + "\n" +
            this.description   + "\n" +
            this.emprunteur    + "\n" +
            this.dateEmprunt;
    }

    //=======================================================================
    // Mthode utilis par indexOf qui teste si deux mdias sont identiques
    //  Deux mdias sont identiques s'ils ont mme identificateur
    //
    public boolean equals(Object o)
    {
        Media m = (Media)o;
        return m.ident.equals(this.ident);
    }
}

