import java.util.*;

public class Emprunteur
{
    /** Numro de carte d'adhrant. */
    private int numero;

    /** Nom de l'emprunteur */
    private String nom;

    /** Prenom de l'emprunteur */
    private String prenom;

    /** Date de naissance.
     Format: JJ/MM/AAAA */
    private String dateNaissance;

    /** Liste des mdias emprunts.
     Chaque lment est l'ident du media. */
    private ArrayList<String> mediaEmpruntes;

    //=======================================================================
    // Constructeur
    public Emprunteur(String nom,
                      String prenom,
                      String dateNaissance)
    {
        this.numero=0;  // Le numero sera initialis par la mdiathque a l'ajout
        this.nom=nom;
        this.prenom=prenom;
        this.dateNaissance=dateNaissance;
        this.mediaEmpruntes = new ArrayList<String>(); // Liste vide 
    }
    
    //=======================================================================
    public int getNumero(){return numero;}
    public void setNumero(int n){numero=n;}

    //=======================================================================
    // Emprunteur sous la forme de chaine
    public String toString()
    {
        String emprunts="";
        for(String m:mediaEmpruntes)
            emprunts= emprunts + m;

        return
            this.numero  + "\n" +
            this.prenom  + "\n" +
            this.nom     + "\n" +
            this.dateNaissance + "\n" +
            emprunts;
    }
}