import java.util.*;

public class Mediatheque
{
    /** La liste des medias. */
    private ArrayList<Media> medias;

    /** La liste des inscrits  la mdiathque  */   
    private ArrayList<Emprunteur> inscrits;

    /** Compteur courant des medias  */
    private int compteurMedia;

    //=======================================================================
    // Constructeur de la mdiathqe
    //
    public Mediatheque()
    {
        this.medias = new ArrayList<Media>();
        this.inscrits = new ArrayList<Emprunteur>();
        this.compteurMedia=1;
    }

    //=======================================================================
    // Mthode qui ajoute un nouveau mdia  la mdiathque
    //
    public void ajouterMedia(String categorie,
                             String sousCategorie,
                             String description)
    {
        // On consruit l'identificateur
        Calendar date = Calendar.getInstance();
        int annee     = date.get(Calendar.YEAR);
        int mois      = date.get(Calendar.MONTH);
        String ident  = String.format("%d-%d-%d",annee,mois,compteurMedia);

        // On incrmente le compteur pour la prochaine cration
        compteurMedia++;
        
        // Cration du mdia
        Media m = new Media(ident,
                            categorie,
                            sousCategorie,
                            description);

        // Ajout du mdia dans la collection des mdias de la mdiathque
        medias.add(m);
    }

    //=======================================================================
    // Mthode qui ajoute un emprunteur  la mdiathque
    //   Le numro d'inscription est plus 1 sur le dernier numro.
    //
    public void ajouterInscrit(Emprunteur e)
    {
        e.setNumero(getNumeroInscrit());
        inscrits.add(e);
    }

    //=======================================================================
    // Affiche dans la console le contenu de la mdiathque : 
    //    - la liste des mdias
    //    - la liste des inscrits
    //
    public void afficher()
    {
        Terminal.ecrireStringln("Les medias de la mediatheque :");
        for(Media m:medias)
            {
                Terminal.ecrireStringln(m.toString());
                Terminal.ecrireStringln("-------------------------");
            }
        
        Terminal.ecrireStringln("Les inscrits de la mediatheque :");
        for(Emprunteur e:inscrits)
            {
                Terminal.ecrireStringln(e.toString());
                Terminal.ecrireStringln("-------------------------");
            }
         }


    //=======================================================================
    //=======================================================================
    //=======================================================================

    // Cette mthode retourne le numro d'inscription le plus haut + 1
    // Ce numro est utilis pour inscrire un nouvel emprunteur.
    //
    private int getNumeroInscrit()
    {
        if (inscrits.size()==0) return 1;


        int max=inscrits.get(0).getNumero();

        for(Emprunteur e:inscrits)
            if(e.getNumero()>max)
                max=e.getNumero();
        return max+1;
    }

}
