import java.util.*;

public class Emprunteur
{
    /** Numro de carte d'adhrant. */
    private int numero;

    /** Nom de l'emprunteur */
    private String nom;

    /** Prenom de l'emprunteur */
    private String prenom;

    /** Date de naissance.
     Format: JJ/MM/AAAA */
    private String dateNaissance;

    /** Liste des mdias emprunts.
     Chaque lment est l'ident du media. */
    private ArrayList<String> mediaEmpruntes;

    //=======================================================================
    // Constructeur d'un emprunteur
    public Emprunteur(String nom,
                      String prenom,
                      String dateNaissance)
    {
        this.numero=0; // Le numero est initialis par la mdiathque
        this.nom=nom;
        this.prenom=prenom;
        this.dateNaissance=dateNaissance;
        this.mediaEmpruntes = new ArrayList<String>();
    }

    //=======================================================================
    // Constructeur utilis pour recherche un emprunteur en fonction 
    //  de son numro d'inscription
    //
    public Emprunteur(int numero)
    {
        this.numero=numero;
    }
    
    //=======================================================================
    public int getNumero(){return numero;}
    public void setNumero(int n){numero=n;}
    public String getNom(){return nom;}
    public String getPrenom(){return prenom;}

    //=======================================================================
    public void addEmprunt(String identMedia)
    {
        mediaEmpruntes.add(identMedia);
    }

    //=======================================================================
    // Emprunteur sous forme de chaine
    //
    public String toString()
    {
        String emprunts="Les medias empruntes: ";
        for(String m:mediaEmpruntes)
            emprunts= emprunts + m;

        return
            this.numero  + "\n" +
            this.prenom  + "\n" +
            this.nom     + "\n" +
            this.dateNaissance + "\n" +
            emprunts;
    }
    
    //=======================================================================
    // Mthode utilis par indexOf pour rechercher un emprunteur.
    // Cette mthide teste si deux emprunteurs sont identiques.
    // Deux emprunteurs sont identiques s'ils ont le mme numro
    //
    public boolean equals(Object o)
    {
        Emprunteur e = (Emprunteur)o;
        return (e.numero==this.numero);
    }
}