import java.util.*;

public class Mediatheque
{
    /** La liste des medias. */
    private ArrayList<Media> medias;

    /** La liste des inscrits  la mdiathque */
    private ArrayList<Emprunteur> inscrits;

    /** Compteur courant des medias  */
    private int compteurMedia;

    //=======================================================================
    // Constructeur de la mdiatque
    public Mediatheque()
    {
        this.medias = new ArrayList<Media>();
        this.inscrits = new ArrayList<Emprunteur>();
        compteurMedia=1;
    }

    //=======================================================================
    // Mthode qui ajoute un nouveau mdia  la mdiathque
    //
    public void ajouterMedia(String categorie,
                             String sousCategorie,
                             String description)
    {
        // On consruit l'identificateur
        Calendar date = Calendar.getInstance();
        int annee = date.get(Calendar.YEAR);
        int mois  = date.get(Calendar.MONTH);
        String ident = String.format("%d-%d-%d",annee,mois,compteurMedia);

        // On incrmente le compteur pour la prochaine cration
        compteurMedia++;
        
        // Cration du mdia
        Media m = new Media(ident,
                            categorie,
                            sousCategorie,
                            description);

        // Ajout du mdia dans la collection des mdias de la mdiathque
        medias.add(m);
    }

    //=======================================================================
    // Mthode qui ajoute un emprunteur  la mdiathque
    //   Le numro d'inscription est plus 1 sur le dernier numro.
    //
    public void ajouterInscrit(Emprunteur e)
    {
        e.setNumero(getNumeroInscrit());
        inscrits.add(e);
    }

    //=======================================================================
    // Mthode qui permet d'emprunter un media dans la console
    //
    public void emprunterModeConsole()
    {
        // On affiche les emprunteurs en fonction d'un critre de recherche sur
        //   le nom ou le prnom
        //
        Terminal.ecrireStringln("Choix de l'emprunteur");
        Terminal.ecrireString("Saisir un mot qui est recherch dans le nom ou le prnom (\"exit\" pour arrter) : ");
        String mot = Terminal.lireString();
        while (! (mot.equals("exit")))
            {
                for(Emprunteur e:this.inscrits)
                    {
                        if ( (e.getNom().toLowerCase().indexOf(mot.toLowerCase())!=-1) ||
                             (e.getPrenom().toLowerCase().indexOf(mot.toLowerCase())!=-1) )
                            {
                                Terminal.ecrireStringln(e.toString());
                            }
                    }
                Terminal.ecrireStringln("------------------------------");
                Terminal.ecrireString("Nouvelle recherche: ");
                mot = Terminal.lireString();
            }

        // Demande de saisie du numro de l'emprunteur
        //
        Terminal.ecrireString("Numero de l'emprunteur: ");
        int numeroEmprunteur = Terminal.lireInt();

        //On affiche les medias en fonction d'un critere de recherche sur
        //  categorie, sous-catgorie ou description
        //
        Terminal.ecrireStringln("Choix du media");
        Terminal.ecrireString("Saisir un mot qui est recherch dans la categorie, la sous-categorie ou la description (\"exit\" pour arrter) : ");
        mot = Terminal.lireString();
        while (! (mot.equals("exit")))
            {
                for(Media e:this.medias)
                    {
                        if ( (e.getCategorie().toLowerCase().indexOf(mot.toLowerCase())!=-1) ||
                             (e.getSousCategorie().toLowerCase().indexOf(mot.toLowerCase())!=-1) ||
                             (e.getDescription().toLowerCase().indexOf(mot.toLowerCase())!=-1) )
                            {
                                Terminal.ecrireStringln(e.toString());
                            }
                    }
                Terminal.ecrireStringln("------------------------------");
                Terminal.ecrireString("Nouvelle recherche: ");
                mot = Terminal.lireString();
            }

        // Demance de saisie de l'identificateur du media
        //
        Terminal.ecrireString("Identificateur du media : ");
        String identMedia = Terminal.lireString();
        
        // Appel du traitement d'emprunt d'un media par un emprunteur
        emprunter(identMedia,numeroEmprunteur);
        
    }

    //=======================================================================
    // Mthode d'emprunt :
    //   identMedia : identificateur du mdia devant tre emprunt
    //   numeroEmprunteur : numro d'inscription de l'emprunteur
    public void emprunter(String identMedia,int numeroEmprunteur)
    {
        // On recherche le mdia et l'emprunteur
        //
        Media mediaEmprunte = null;
        Emprunteur emprunteur = null;

        Media r = new Media(identMedia);
        int index = medias.indexOf(r);
        if (index==-1)
            {
                Terminal.ecrireStringln("********** Ce media " + identMedia + " n'existe pas");
                return;
            }
        else
            {
                mediaEmprunte = medias.get(index);
            }
        
        Emprunteur e = new Emprunteur(numeroEmprunteur);
        index = inscrits.indexOf(e);
        if (index==-1)
            {
                Terminal.ecrireStringln("********** Cet emprunteur " + numeroEmprunteur + " n'existe pas");
                return;
            }
        else
            {
                emprunteur = inscrits.get(index);
            }
        
        // Le mdia est emprunt par l'emprunteur

        // On renseigne le numro de l'emprunteur
        mediaEmprunte.setEmprunteur(numeroEmprunteur);

        // On renseigne la date d'emprunt
        Calendar cal = Calendar.getInstance();
        mediaEmprunte.setDateEmprunt(cal.get(Calendar.DAY_OF_MONTH)+"/"+cal.get(Calendar.MONTH)+"/"+cal.get(Calendar.YEAR));

        // L'emprunteur a un mdia de plus emprunt
        //
        emprunteur.addEmprunt(identMedia);
        
    }

    //=======================================================================
    // Affiche dans la console le contenu de la mdiathque : 
    //    - la liste des mdias
    //    - la liste des inscrits
    //
    public void afficher()
    {
        Terminal.ecrireStringln("Les medias de la mediatheque :");
        for(Media m:medias)
            {
                Terminal.ecrireStringln(m.toString());
                Terminal.ecrireStringln("-------------------------");
            }
        
        Terminal.ecrireStringln("Les inscrits de la mediatheque :");
        for(Emprunteur e:inscrits)
            {
                Terminal.ecrireStringln(e.toString());
                Terminal.ecrireStringln("-------------------------");
            }
         }


    //=======================================================================
    //=======================================================================
    //=======================================================================

    // Cette mthode retourne le numro d'inscription le plus haut + 1
    // Ce numro est utilis pour inscrire un nouvel emprunteur.
    //
    private int getNumeroInscrit()
    {
        if (inscrits.size()==0) return 1;
        int max=inscrits.get(0).getNumero();
        for(Emprunteur e:inscrits)
            if(e.getNumero()>max)
                max=e.getNumero();
        return max+1;
    }

}
