// Exercice sur le probleme des 8 reines.
//  
import fr.cnam.ihm.*;

public class Exercice07
{
    /** mthode principale de l'exercice */
    public static void main(String... args)
    {
        int[][] echiquier; // 1 case occupe par une reine
        int colCour;       // Colonne courante pour placer une reine

        echiquier = new int[8][8];
        colCour=0;
        boolean fini = false;
        while (! fini)
            {
                boolean reussi = placerReine(echiquier,colCour);
                // Si la reine n'a pu etre placer dans la colonne
                //  cette methode enleve la reine de la colonne

                if (reussi)
                    {
                        afficherEchiquier(echiquier);
                        //Terminal.lireString();
                        if (colCour==7) fini = true;
                        else
                            colCour = colCour + 1;
                    }
                else
                    {
                        if (colCour==0) // Pas de solution
                            fini = true;
                        else
                            colCour = colCour-1;
                    }
            }
        afficherEchiquier(echiquier);
        afficherEchiquierIHM(echiquier);
    }

    private static boolean placerReine(int[][] echiquier,int colCour)
    {
        /*
          Tester s'il existe deja une reine dans la colonne colCour;
          Si existe
          Alors 
            la deplacer en avant jusqu'a une case libre;
            Si pas de case libre alors
              enlever la reine de la colonne;
              reussi = faux;
            Sinon
              mettre la reine  cette case libre;
              reussi = vrai;
            Finsi
          Sinon
            trouver une case libre;
            Si pas trouve alors
              reussi = faux;
            Sinon
              mettre la reine  cette case libre;
              reussi = vrai;
            Finsi
          Finsi
        */

        boolean reussi;

        //Tester s'il existe deja une reine dans la colonne colCour;
        int posReine=-1;
        for(int i=0;i<8;i++)
            if (echiquier[i][colCour]==1)
                {
                    posReine=i;
                    break;
                }
        //
        if (posReine!=-1)
            {
                int posLibre = determinerCaseLibre(echiquier,posReine,colCour);
                if (posLibre==-1)
                    {
                        echiquier[posReine][colCour]=0;
                        reussi=false;
                    }
                else
                    {
                        echiquier[posLibre][colCour]=1;
                        reussi=true;
                    }
            }
        else
            {
                int posLibre = determinerCaseLibre(echiquier,-1,colCour);
                if (posLibre==-1)
                    {
                        reussi=false;
                    }
                else
                    {
                        echiquier[posLibre][colCour]=1;
                        reussi=true;
                    }
            }

        return reussi;
    }
    
    


    //Methode qui determine la 1ere case libre dans une colonne
    // a partir d'une position (exclus)
    // Retourne -1 si pas trouv
    private static int determinerCaseLibre(int[][] echiquier,int ligneReine,int colonneReine)
    {
        int ligneDebut;
        
        if (ligneReine==7) return -1;
        if (ligneReine==-1) ligneDebut=0;
        else 
            {
                ligneDebut=ligneReine+1;
                echiquier[ligneReine][colonneReine]=0;
            }

        int posTrouve=-1;
        for(int l=ligneDebut;l<8;l++)
            {
                if (caseLibre(echiquier,l,colonneReine))
                    {
                        posTrouve=l;
                        break;
                    }
            }
        return posTrouve;
    }
    

    //Methode qui determine si une case est libre (pas en prise par une reine)
    private static boolean caseLibre(int[][] echiquier,int ligne,int colonne)
    {
        for(int sensL=0;sensL<3;sensL++)
            for(int sensC=0;sensC<3;sensC++)
                if (existeReineSens(echiquier,ligne,colonne,sensL-1,sensC-1)) return false;
        return true;
    }

    
    //Methode qui teste si il existe une reine dans un sens
    private static boolean existeReineSens(int[][] echiquier,int ligne,int colonne,int sensL,int sensC)
    {
        for(int k=0;k<8;k++)
            {
                int lCour = ligne+k*sensL;
                int cCour = colonne+k*sensC;
                if ((lCour>=0)&&(lCour<=7)&&
                    (cCour>=0)&&(cCour<=7))
                    if (echiquier[lCour][cCour]==1)
                        return true;
            }
        return false;
    }

    static private void afficherEchiquier(int[][] echiquier)
    {
        for(int l=0;l<8;l++)
            {
                for(int c=0;c<8;c++)
                    if (echiquier[l][c]==1) System.out.print(" X");
                    else System.out.print(" .");
                System.out.println("");
            }
        System.out.println("----------------");
    }

    static private void afficherEchiquierIHM(int[][] echiquier)
    {
        CanvasIHM grille = CanvasIHM.creerCanvasIhmDansFrame(8,8,15);
        grille.afficherFrame(10,10);
        for(int l=0;l<8;l++)
            {
                for(int c=0;c<8;c++)
                    if (echiquier[l][c]==1) 
                        grille.setMarque(1,l,c);
            }

    }

}
