import java.util.*;

import fr.cnam.util.*;

// Classe de gestion d'un distributeur de boisson
//
public class Distributeur
{
  
  public  final static String[] boissons ={"CAFE","CHOCOLAT","COCA COLA"};
  private final static int[] prix = {20,30,120};
  public  final static int[] piecesType = {10,20,50,100,200};
  public  final static String[] piecesTypeString = {"0.10","0.20","0.50","1.0","2.0"};

  private ArrayList<Integer> piecesIntroduites;
  private ArrayList<Integer> piecesARendre;
  private ArrayList<Integer> piecesEnStock;
  private Hashtable<String,Integer> stockBoissons;  // boisson, nombre
  private String boissonCommandee;
  private int sucreCommande;

  // Constructeur
  //   les pieces du stock initial sont dans un fichier
  //   le nombre des boisson sont dans un fichier
  //
  public Distributeur()
  {
    piecesIntroduites = new ArrayList<Integer>();
    piecesARendre = new ArrayList<Integer>();
    piecesEnStock = new ArrayList<Integer>();
    String[] lignes = Terminal.lireFichierTexte("data/StockPieces.txt");
    for(String s:lignes)
      piecesEnStock.add(Integer.parseInt(s));
    stockBoissons = new Hashtable<String,Integer>();
    lignes = Terminal.lireFichierTexte("data/StockBoissons.txt");
    for(String s:lignes)
      {
        String[] ts = s.split("=", 2);
        stockBoissons.put(ts[0],Integer.parseInt(ts[1]));
      }
    sucreCommande=0;
  }

  // Pour afficher l'etat du distributeur
  //  retourne le distributeur sous la forme d'une chaine
  //  de caractere
  //
  public String toString()
  {
    String res="";
    res=res+"Pieces en stock : \n";
    for(int v:piecesType)
      {
        int nb=0;
        for(Integer vp : piecesEnStock)
          {
            if (v==vp.intValue())
              nb++;
          }
        res=res+String.format("%3d : %3d\n",v,nb);
      }
    res=res+"Boissons en stock : \n";
    for(String b:boissons)
      res=res+String.format("%20s : %2d\n",b,stockBoissons.get(b));
    res=res+"Pieces introduites : \n";
    for(int v:piecesType)
      {
        int nb=0;
        for(Integer vp : piecesIntroduites)
          {
            if (v==vp.intValue())
              nb++;
          }
        res=res+String.format("%3d : %3d\n",v,nb);
      }
    return res;
  }

  // Ajouter une pieces dans la liste des pieces introduites
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  public String ajouterPieceIntroduite(int piece)
  {
    String res="";
    piecesIntroduites.add(piece);
    res=res+"Introduction d'une piece de : "+piece+" cents"+"\n";
    return res;
  }

  // Traitement lors du choix d'une boisson
  //   en parametre le nom de la boisson choisie
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  public String commanderBoisson(String boisson)
  {
    String res="";

    boissonCommandee=boisson;
    // Si la boisson est en stock
    if (stockBoissons.get(boisson)!=0)
      {
        // Recherche du prix de la boisson
        int prixBoisson=0;
        for(int i=0;i<boissons.length;i++)
          if (boissons[i].equals(boisson))
            prixBoisson = prix[i];
        
        // Calcul du montant des pieces introduites
        int montantIntroduit = 0;
        for(Integer v:piecesIntroduites)
          montantIntroduit=montantIntroduit+v;
        
        // Calcul du montant a rendre
        int montantARendre = montantIntroduit-prixBoisson;

        // Si pas assez de pieces introduites
        if (montantARendre<0)
          res="Montant introduit pas suffisant\n";
        else
          {
            // determiner les pieces a rendre
            boolean rendu = determinerPiecesARendre(montantARendre);

            // si impossible de rendre la monnaie
            if (!rendu)
              {
                res="Pas assez de monnaie dans le distributeur\nVoulez-vous continuer?\n";
              }
            else 
              {
                // On distribue la boisson et on rend la monnaie
                res=distribuerBoisson();
                finDistribution();
              }
          }
      }
    else // la boisson n'est pas en stock
      {
        res="La boisson n'est pas disponible\n";
        res=res+annuler();
      }
    return res;
  }

  // Dans le cas ou le distributeur ne peut pas rendre la monnaie
  //   on peut continuer et distribuer la boisson sans rendre la monnaie
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  public String continuerLaDistributionDeLaBoisson()
  {
    String res="";
    // Le distributeur garde les pieces introduites
    for(Integer v:piecesIntroduites)
    	piecesEnStock.add(v);
    // Distribution de la boisson
    res = distribuerBoisson();
    return res;
  }

  // Action d'annulation de la distribution
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  public String annuler()
  {
    String  res;

    res=rendreLaMonnaie();
    res=res+rendreLesPiecesIntroduites();
    finDistribution();

    return res;
  }

  // Mise a jour de la dose de sucre
  //
  public void setSucreCommande(int sucre){this.sucreCommande=sucre;}

  // Distribution de la boisson et rendre la monnaie
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  private String distribuerBoisson()
  {
    String res="";

    // Rendre la monnaie
    res=rendreLaMonnaie();

    // Preparation de la boisson
    res=res+"Preparation de la boisson : "+boissonCommandee+"\n";

    // Decrementation du stock de la boisson
    stockBoissons.put(boissonCommandee,
                      stockBoissons.get(boissonCommandee)-1);
    
    // Dose de sucre et signal sonore
    res=res+"Dose de sucre : "+sucreCommande+"\n";
    res=res+"Envoi du signal sonore"+"\n";
    finDistribution();

    return res;
  }

  // Fin de la distribution : mise a jour des attributs courants a vide
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  private void finDistribution()
  {
    sucreCommande=0;
    boissonCommandee=null;
    piecesIntroduites.clear();
    piecesARendre.clear();
  }

  // On rend les pieces a rendre
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  private String rendreLaMonnaie()
  {
    String res="Rendre la monnaie:\n";
    for(Integer v:piecesARendre)
      res=res+v+"\n";
    return res;
  }
  
  // On rend les pieces introduites
  //  retourne en chaine ce que l'IHM doit afficher comme resultat
  //  de l'action
  //
  private String rendreLesPiecesIntroduites()
  {
    String res="Rendre les pieces introduites:\n";
    for(Integer v:piecesIntroduites)
      res=res+v+"\n";
    return res;
  }
  
  // Traitement qui permet de determiner les pieces a rendre
  //   En parametre : le montant a rendre
  //
  // Le principe : 
  //    on gere un stock de pieces temporaire dans lequel on
  //       ajoute les pieces introduites et les pieces du stock
  //    on essaye de decrementer ce stock en fonction du montant
  //       a rendre
  //    si il est possible de rendre les pieces a rendre alors
  //      on remplace le stock avec celui temporaire
  //    sinon on fait rien
  //
  //  Cette methode retourne vrai s'il est possible de rendre les pieces
  //   et l'attribut piecesARendre contient la liste des pieces a rendre
  //   sinon retourne faux
  //
  private boolean determinerPiecesARendre(int montantARendre)
  {
    boolean rendu;
    int m = montantARendre;
    piecesARendre.clear();

    // Creation du stock temporaire = pieces du stock + pieces introduites
    ArrayList<Integer> stockPiecesTmp = new ArrayList<Integer>();
    for(Integer v:piecesEnStock) stockPiecesTmp.add(v);
    for(Integer v:piecesIntroduites) stockPiecesTmp.add(v);

    // Pour chaque valeur de piece de la plus grande a la plus petite valeur
    for(int i=piecesType.length-1;i>=0;i--)
      {
        Integer valPiece = piecesType[i];
        boolean fini = false;
        // On rend toutes les pieces de valeur valPiece jusqu'a ce que la
        //   somme restante soit inferieure a valPiece
        while (! fini)
          {
            if (m<valPiece) fini=true;
            else
              {
                // Recherche de la piece a rendre dans le monnayeur temporaire
                boolean contient=false;
                for(Integer v:stockPiecesTmp)
                  if (v.equals(valPiece)) contient=true;
                // Si elle existe alors rendre la piece
                if (contient)
                  {
                    piecesARendre.add(valPiece);
                    m=m-valPiece;

                    // On enleve la piece du monnayeur temporaire
                    for(int k=0;k<stockPiecesTmp.size();k++)
                      if (valPiece.equals(stockPiecesTmp.get(k))) 
                        {
                          stockPiecesTmp.remove(k);
                          break;
                        }
                  }
                else
                  fini=true;
              }
          }
      }
    // Si on a pu rendre toute la monnaie
    if (m==0)
      {
        piecesEnStock=stockPiecesTmp;
        rendu=true;
      }
    else 
    {
    	piecesARendre.clear();
    	rendu=false;
    }

    return rendu;
  }

}