import fr.cnam.ihm.*;

// Classe de definition de l'IHM
//
public class IHMDistributeur implements FormulaireInt
{
  private Distributeur distributeur;  // Le disctributeur
  private String resultat;            // Le texte de la zone de resultat

  // Constructeur
  //
  public IHMDistributeur(Distributeur distributeur)
  {
    // Initialisation des attributs
    this.distributeur = distributeur;
    this.resultat="";

    // Creation du formulaire
    Formulaire form = new Formulaire("DISTRIBUTEUR",this,800,600);

    // Creation de l'IHM

    form.addListeChoix("PIECE",
                       "Introduire une pice",
                       Distributeur.piecesTypeString,
                       true,
                       Distributeur.piecesTypeString[0]);


    String[] dosesSucre = {"0","1","2","3","4","5"};
    form.addListeChoix("SUCRE",
                       "Choisir la dose de sucre",
                       dosesSucre,
                       true,
                       "0");

    form.addListeChoix("BOISSON",
                       "Choisur une bBoisson",
                       Distributeur.boissons,
                       true,
                       Distributeur.boissons[0]);
    form.addButton("CONTINUER","Continuer");
    form.addButton("NEPASCONTINUER","Ne pas continuer");
    form.addButton("ANNULER","Annuler");
    form.addButton("ETAT","Etat du distributeur");



    form.setPosition(300,0);
    form.addZoneText("RESULTAT",
                     "Resultat",
                     false,
                     "",
                     400,
                     580);
    form.afficher();
  }
  
  // Actions de l'utilisateur
  //
  public void submit(Formulaire form,String nomSubmit)
  {
    // Action d'introduction d'une piece
    //
    if (nomSubmit.equals("PIECE"))
      {
        int piece = (int)(Double.parseDouble(form.getValeurChamp("PIECE"))*100);
        String res = distributeur.ajouterPieceIntroduite(piece);
        resultat = resultat + res;
      }

    // Action de choix de la dose de sucre
    //
    if (nomSubmit.equals("SUCRE"))
      {
        String sucre = form.getValeurChamp("SUCRE");
        distributeur.setSucreCommande(Integer.parseInt(sucre));
        resultat = resultat + "Choix du sucre : "+sucre+"\n";
      }

    // Action du choix de la boisson
    //
    if (nomSubmit.equals("BOISSON"))
      {
        String boisson = form.getValeurChamp("BOISSON");
        String res = distributeur.commanderBoisson(boisson);
        resultat = resultat + res;
      }

    // Action de continuer la distribution de la boisson dans le cas
    //   ou le distributeur n'a pas assez de pieces a rendre
    //
    if (nomSubmit.equals("CONTINUER"))
      {
        String res = distributeur.continuerLaDistributionDeLaBoisson();
        resultat = resultat + res;
      }

    // Action de le pas continuer la distribution de la boisson dans le cas
    //   ou le distributeur n'a pas assez de pieces a rendre
    //
    if (nomSubmit.equals("NEPASCONTINUER"))
      {
        String res = distributeur.annuler();
        resultat = resultat + res;
      }

    if (nomSubmit.equals("ANNULER"))
      {
        String res = distributeur.annuler();
        resultat = resultat + res;
      }

    // Action d'afficher l'etat du distributeur
    //
    if (nomSubmit.equals("ETAT"))
      {
        resultat = resultat + "------------------------------\n";
        resultat = resultat + distributeur.toString()+"\n";
        resultat = resultat + "------------------------------\n";
      }

    // Dans tous les cas, une fois l'action faite on
    //   met a jour la zone de resultat avec le resultat de l'action
    //
    form.setValeurChamp("RESULTAT",resultat);
  }
}

