/*
 * Decompiled with CFR 0.152.
 */
package fr.cnam.ihm;

import fr.cnam.ihm.ControlesCanvasIHM;
import fr.cnam.ihm.GrilleWindowAdapter;
import fr.cnam.ihm.LigneCanvas;
import fr.cnam.ihm.PolygoneCanvas;
import fr.cnam.ihm.Position;
import fr.cnam.ihm.RessourcesCanvas;
import fr.cnam.ihm.TexteCanvas;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CanvasIHM {
    private static final int NB_MAX_MARQUE = 10;
    public static int TYPE_MARQUE = 1;
    private JFrame fen;
    private JPanel _panelPP;
    private Canvas _canvas;
    private ControlesCanvasIHM _actions;
    private int _nbX;
    private int _nbY;
    private int _tailleCase;
    private int[][] _grille;
    private ArrayList<LigneCanvas> _lignes;
    private ArrayList<TexteCanvas> _textes;
    private ArrayList<PolygoneCanvas> _polygones;
    private int _xCanvas;
    private int _yCanvas;
    private int _width;
    private int _height;
    private Color[] _couleurs;
    private boolean _afficherGrille;

    public CanvasIHM(int n, int n2, int n3) {
        this._afficherGrille = true;
        this.initCanvasIHM(n, n2, n3);
    }

    public CanvasIHM(int n, int n2) {
        this._afficherGrille = false;
        this.initCanvasIHM(n, n2, 1);
    }

    private void initCanvasIHM(int n, int n2, int n3) {
        this.fen = null;
        this._panelPP = new JPanel();
        this._panelPP.setLayout(null);
        this._tailleCase = n3;
        this._nbX = n;
        this._nbY = n2;
        this._xCanvas = 5;
        this._yCanvas = 5;
        this._width = this._nbX * this._tailleCase + 1;
        this._height = this._nbY * this._tailleCase + 1;
        this._couleurs = new Color[10];
        this._couleurs[0] = Color.black;
        this._couleurs[1] = Color.cyan;
        this._couleurs[2] = Color.blue;
        this._couleurs[3] = Color.gray;
        this._couleurs[4] = Color.green;
        this._couleurs[5] = Color.magenta;
        this._couleurs[6] = Color.orange;
        this._couleurs[7] = Color.yellow;
        this._couleurs[8] = Color.red;
        this._couleurs[9] = Color.white;
        this._canvas = new PaintCanvas(this);
        this._canvas.resize(this._width, this._height);
        this._grille = new int[this._nbX][this._nbY];
        this.razGrille();
        this._lignes = new ArrayList();
        this._textes = new ArrayList();
        this._polygones = new ArrayList();
        this._actions = null;
        this._canvas.setBounds(this._xCanvas, this._yCanvas, this._width, this._height);
        this._panelPP.add(this._canvas);
        this._canvas.addMouseListener(new SourisAction(this));
    }

    public void setActions(ControlesCanvasIHM controlesCanvasIHM) {
        this._actions = controlesCanvasIHM;
    }

    public JPanel getPanel() {
        return this._panelPP;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void razGrille() {
        for (int i = 0; i < this._nbX; ++i) {
            for (int j = 0; j < this._nbY; ++j) {
                this._grille[i][j] = 0;
            }
        }
    }

    public void setMarque(int n, int n2, int n3) {
        this._grille[n2][n3] = n;
        this.marquer(n, n2, n3);
    }

    public void ajouterLigne(int n, int n2, int n3, int n4, int n5) {
        this._lignes.add(new LigneCanvas(n, n2, n3, n4, n5));
        this.dessinerLignes();
    }

    public void ajouterTexte(String string, int n, int n2, int n3) {
        this._textes.add(new TexteCanvas(string, n, n2, n3));
        this.dessinerTextes();
    }

    public void ajouterPolygone(Object object, Position position, int n, Point ... pointArray) {
        this._polygones.add(new PolygoneCanvas(object, position, n, pointArray));
        this.dessinerPolygones();
    }

    public void ajouterPolygone(RessourcesCanvas ressourcesCanvas, Object object, Position position, Point ... pointArray) {
        this._polygones.add(new PolygoneCanvas(ressourcesCanvas, object, position, pointArray));
        this.dessinerPolygones();
    }

    public int getMarque(int n, int n2) {
        return this._grille[n][n2];
    }

    public boolean siCaseLibre(int n, int n2) {
        return this.getMarque(n, n2) == 0;
    }

    public int getNbX() {
        return this._nbX;
    }

    public int getNbY() {
        return this._nbY;
    }

    public int getNbMaxMarqueur() {
        return 10;
    }

    public void desafficherGrille() {
        Graphics graphics = this._canvas.getGraphics();
        this._afficherGrille = false;
        graphics.clearRect(0, 0, this._width + 1, this._height + 1);
    }

    public void afficherGrille() {
        this._afficherGrille = true;
        this.dessinerGrille();
    }

    public static CanvasIHM creerCanvasIhmDansFrame(int n, int n2, int n3) {
        JFrame jFrame = new JFrame();
        CanvasIHM canvasIHM = new CanvasIHM(n, n2, n3);
        canvasIHM.fen = jFrame;
        jFrame.add(canvasIHM.getPanel());
        GrilleWindowAdapter grilleWindowAdapter = new GrilleWindowAdapter();
        jFrame.addWindowListener(grilleWindowAdapter);
        return canvasIHM;
    }

    public void afficherFrame(int n, int n2) {
        this.fen.setLocation(n, n2);
        this.fen.setPreferredSize(new Dimension(this._width + 20, this._height + 20));
        this.fen.pack();
        this.fen.show();
    }

    public JFrame getFrame() {
        return this.fen;
    }

    public ArrayList<LigneCanvas> getLignes() {
        return this._lignes;
    }

    public ArrayList<TexteCanvas> getTextes() {
        return this._textes;
    }

    public ArrayList<PolygoneCanvas> getPolygones() {
        return this._polygones;
    }

    private void dessinerGrille() {
        Point point;
        Point point2;
        int n;
        Graphics graphics = this._canvas.getGraphics();
        if (graphics == null) {
            System.out.println("Le graphic est null. Les instrucitons de dessin doivent se faire apr\u00e8s l'affichage du formulaire qui contient le canvas.");
            return;
        }
        graphics.clearRect(0, 0, this._width + 1, this._height + 1);
        for (n = 0; n < this._nbX + 1; ++n) {
            point2 = new Point(this._width / this._nbX * n, 0);
            point = new Point(this._width / this._nbX * n, this._height);
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
        }
        for (n = 0; n < this._nbY + 1; ++n) {
            point2 = new Point(0, this._height / this._nbY * n);
            point = new Point(this._width, this._height / this._nbY * n);
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
        }
        for (n = 0; n < this._nbX; ++n) {
            for (int i = 0; i < this._nbY; ++i) {
                this.marquer(this._grille[n][i], n, i);
            }
        }
    }

    private void dessinerLignes() {
        Graphics graphics = this._canvas.getGraphics();
        if (graphics == null) {
            System.out.println("Le graphic est null. Les instrucitons de dessin doivent se faire apr\u00e8s l'affichage du formulaire qui contient le canvas.");
            return;
        }
        for (int i = 0; i < this._lignes.size(); ++i) {
            LigneCanvas ligneCanvas = this._lignes.get(i);
            if (ligneCanvas.rc == null) {
                graphics.setColor(this._couleurs[ligneCanvas.marque - 1]);
            } else {
                graphics.setColor(ligneCanvas.rc.getForeground());
            }
            graphics.drawLine(ligneCanvas.p1.x, ligneCanvas.p1.y, ligneCanvas.p2.x, ligneCanvas.p2.y);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dessinerPolygones() {
        Graphics graphics = this._canvas.getGraphics();
        Collections.sort(this._polygones);
        if (graphics == null) {
            System.out.println("Le graphic est null. Les instrucitons de dessin doivent se faire apr\u00e8s l'affichage du formulaire qui contient le canvas.");
            return;
        }
        for (int i = 0; i < this._polygones.size(); ++i) {
            PolygoneCanvas polygoneCanvas = this._polygones.get(i);
            if (polygoneCanvas.rc == null) {
                graphics.setColor(this._couleurs[polygoneCanvas.marque - 1]);
            } else {
                graphics.setColor(polygoneCanvas.rc.getBackground());
            }
            int[] nArray = new int[polygoneCanvas.points.length];
            int[] nArray2 = new int[polygoneCanvas.points.length];
            int n = 0;
            Point[] pointArray = polygoneCanvas.points;
            int n2 = pointArray.length;
            for (int j = 0; j < n2; ++j) {
                Point point = pointArray[j];
                nArray[n] = point.x;
                nArray2[n] = point.y;
                ++n;
            }
            graphics.fillPolygon(nArray, nArray2, polygoneCanvas.points.length);
            if (polygoneCanvas.rc == null) {
                graphics.setColor(this._couleurs[0]);
            } else {
                graphics.setColor(polygoneCanvas.rc.getForeground());
            }
            Point point = polygoneCanvas.points[0];
            for (n2 = 1; n2 < polygoneCanvas.points.length; ++n2) {
                void object;
                graphics.drawLine(object.x, object.y, polygoneCanvas.points[n2].x, polygoneCanvas.points[n2].y);
                Point point2 = polygoneCanvas.points[n2];
            }
            graphics.drawLine(polygoneCanvas.points[polygoneCanvas.points.length - 1].x, polygoneCanvas.points[polygoneCanvas.points.length - 1].y, polygoneCanvas.points[0].x, polygoneCanvas.points[0].y);
        }
    }

    private void dessinerTextes() {
        Graphics graphics = this._canvas.getGraphics();
        if (graphics == null) {
            System.out.println("Le graphic est null. Les instrucitons de dessin doivent se faire apr\u00e8s l'affichage du formulaire qui contient le canvas.");
            return;
        }
        for (TexteCanvas texteCanvas : this._textes) {
            if (texteCanvas.rc == null) {
                graphics.setColor(this._couleurs[texteCanvas.couleur - 1]);
            } else {
                graphics.setColor(texteCanvas.rc.getForeground());
            }
            graphics.drawString(texteCanvas.texte, texteCanvas.p.x, texteCanvas.p.y);
        }
    }

    public void effacerCanvas() {
        this._lignes.clear();
        this._textes.clear();
        this._polygones.clear();
        Graphics graphics = this._canvas.getGraphics();
        if (graphics == null) {
            System.out.println("Le graphic est null. Les instrucitons de dessin doivent se faire apr\u00e8s l'affichage du formulaire qui contient le canvas.");
            return;
        }
        graphics.clearRect(0, 0, this._width + 1, this._height + 1);
    }

    private void marquer(int n, int n2, int n3) {
        Graphics graphics = this._canvas.getGraphics();
        int n4 = n2 * (this._width / this._nbX);
        int n5 = (n2 + 1) * (this._width / this._nbX);
        int n6 = n3 * (this._height / this._nbY);
        int n7 = (n3 + 1) * (this._height / this._nbY);
        graphics.clearRect(n4 + 1, n6 + 1, n5 - n4 - 2, n7 - n6 - 2);
        if (n > 0) {
            graphics.setColor(this._couleurs[n - 1]);
            if (TYPE_MARQUE == 1) {
                graphics.fillRect(n4 + 2, n6 + 2, n5 - n4 - 4, n7 - n6 - 4);
            } else {
                graphics.fillOval(n4 + 2, n6 + 2, n5 - n4 - 4, n7 - n6 - 4);
            }
        }
    }

    private Point pointToCase(Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = n / this._tailleCase;
        int n4 = n2 / this._tailleCase;
        if (n3 < 0 || n3 >= this._nbX || n4 < 0 || n4 >= this._nbY) {
            return null;
        }
        return new Point(n3, n4);
    }

    private Object pointToPolygone(Point point) {
        int n = point.x;
        int n2 = point.y;
        for (int i = this._polygones.size() - 1; i >= 0; --i) {
            if (!this._polygones.get((int)i).polygone.contains(point)) continue;
            return this._polygones.get((int)i).object;
        }
        return null;
    }

    class SourisAction
    extends MouseAdapter {
        CanvasIHM _ihm;

        public SourisAction(CanvasIHM canvasIHM2) {
            this._ihm = canvasIHM2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (CanvasIHM.this._afficherGrille) {
                Point point = CanvasIHM.this.pointToCase(mouseEvent.getPoint());
                if (point != null && CanvasIHM.this._actions != null) {
                    CanvasIHM.this._actions.pointerCaseGrille(point.x, point.y, this._ihm);
                }
            } else {
                Point point = mouseEvent.getPoint();
                if (CanvasIHM.this._actions != null) {
                    Object object = CanvasIHM.this.pointToPolygone(mouseEvent.getPoint());
                    CanvasIHM.this._actions.pointerCanvas(object, point.x, point.y, this._ihm);
                }
            }
        }
    }

    class PaintCanvas
    extends Canvas {
        CanvasIHM _g;

        public PaintCanvas(CanvasIHM canvasIHM2) {
            this._g = canvasIHM2;
        }

        @Override
        public void paint(Graphics graphics) {
            if (CanvasIHM.this._afficherGrille) {
                this._g.dessinerGrille();
            }
            this._g.dessinerLignes();
            this._g.dessinerTextes();
            this._g.dessinerPolygones();
        }
    }
}

