/*
 * Decompiled with CFR 0.152.
 */
package fr.cnam.ihm;

import fr.cnam.ihm.CanvasIHM;
import fr.cnam.ihm.ControlesCanvasIHM;
import fr.cnam.ihm.FormulaireInt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class Formulaire {
    private FormulaireInt app;
    private JFrame frame;
    private int widthFrame;
    private int heightFrame;
    private JPanel panelPP;
    private ArrayList<JButton> buttons;
    private String buttonFermer;
    private Exception exceptionForm;
    private int xCour;
    private int yCour;
    private int widthLabelCour;
    private int widthGapCour;
    private int widthTextCour;
    private int widthButtonCour;
    private boolean sensHorizontal;
    private boolean sensVertical;
    private String font;
    private boolean autoWidth;
    private int tailleFonte = 11;
    private int heightText = 20;
    private Hashtable<String, JComponent> elements;

    public Formulaire(String string, FormulaireInt formulaireInt, int n, int n2) {
        this.initFormulaire(string, formulaireInt, n, n2, true);
    }

    public Formulaire(String string, FormulaireInt formulaireInt, int n, int n2, boolean bl) {
        this.initFormulaire(string, formulaireInt, n, n2, bl);
    }

    private void initFormulaire(String string, FormulaireInt formulaireInt, int n, int n2, boolean bl) {
        this.app = formulaireInt;
        if (bl) {
            this.frame = new JFrame(string);
            this.widthFrame = n;
            this.heightFrame = n2;
        } else {
            this.frame = null;
        }
        this.buttonFermer = "";
        this.font = "Courier";
        this.panelPP = new JPanel();
        this.panelPP.setLayout(null);
        if (this.frame != null) {
            this.frame.add(this.panelPP);
            this.frame.addWindowListener(new FormulaireWindowListener());
        }
        this.xCour = 0;
        this.yCour = 0;
        this.widthLabelCour = 100;
        this.widthGapCour = 0;
        this.widthTextCour = 100;
        this.widthButtonCour = 100;
        this.sensVertical = true;
        this.sensHorizontal = false;
        this.autoWidth = true;
        this.elements = new Hashtable();
    }

    public void setApp(FormulaireInt formulaireInt) {
        this.app = formulaireInt;
    }

    public JPanel getPanel() {
        return this.panelPP;
    }

    public int getXCour() {
        return this.xCour;
    }

    public int getYCour() {
        return this.yCour;
    }

    public void setPosition(int n, int n2) {
        this.xCour = n;
        this.yCour = n2;
    }

    public void addPosition(int n, int n2) {
        this.xCour += n;
        this.yCour += n2;
    }

    public void setTailleFonte(int n) {
        this.tailleFonte = n;
    }

    public void setHeightText(int n) {
        this.heightText = n;
    }

    public void dessous(int n) {
        this.xCour = n;
        this.yCour = this.yCour + this.heightText + 3;
    }

    public void horizontal() {
        this.sensHorizontal = true;
        this.sensVertical = false;
    }

    public void vertical() {
        this.sensHorizontal = false;
        this.sensVertical = true;
    }

    public void setAutoWidth(boolean bl) {
        this.autoWidth = bl;
    }

    public void setWidthLabelCour(int n) {
        this.widthLabelCour = n;
    }

    public void setWidthTextCour(int n) {
        this.widthTextCour = n;
    }

    public void setWidthGapCour(int n) {
        this.widthGapCour = n;
    }

    public void setWidthButtonCour(int n) {
        this.widthButtonCour = n;
    }

    public void afficher() {
        this.frame.setPreferredSize(new Dimension(this.widthFrame + 15, this.heightFrame + 40));
        this.frame.pack();
        this.frame.show();
    }

    public void afficher(int n, int n2) {
        this.frame.setLocation(n, n2);
        this.afficher();
    }

    public void fermer() {
        this.frame.dispose();
    }

    public void addLabel(String string) {
        int n = this.xCour;
        int n2 = this.yCour;
        int n3 = this.widthLabelCour;
        if (this.sensHorizontal) {
            this.xCour += this.widthLabelCour;
        }
        if (this.sensVertical) {
            this.yCour = n2 + this.heightText + 3;
        }
        JLabel jLabel = new JLabel(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        Font font = new Font(this.font, 1, this.tailleFonte);
        jLabel.setFont(font);
        if (this.autoWidth) {
            n3 = jLabel.getFontMetrics(font).stringWidth(string);
        }
        jLabel.setBounds(0, 0, n3, this.heightText);
        jPanel.add(jLabel);
        jPanel.setBounds(n, n2, n3, this.heightText);
        this.panelPP.add(jPanel);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public void addText(String string, String string2, boolean bl, String string3) {
        int n = this.xCour;
        int n2 = this.yCour;
        int n3 = this.widthLabelCour;
        int n4 = this.widthGapCour;
        int n5 = this.widthTextCour;
        if (this.sensHorizontal) {
            this.xCour = n + n3 + n4 + n5 + 3;
        }
        if (this.sensVertical) {
            this.yCour = n2 + this.heightText + 3;
        }
        JLabel jLabel = new JLabel(string2);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(bl);
        jTextField.setText(string3);
        this.elements.put(string, jTextField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        Font font = new Font(this.font, 1, this.tailleFonte);
        jLabel.setFont(font);
        jTextField.setFont(font);
        if (this.autoWidth) {
            n3 = jLabel.getFontMetrics(font).stringWidth(string2) + 3;
        }
        jLabel.setBounds(0, 0, n3, this.heightText);
        jTextField.setBounds(n3 + n4, 0, n5, this.heightText);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.setBounds(n, n2, n3 + n4 + n5, this.heightText);
        this.panelPP.add(jPanel);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public void addListeChoix(String string, String string2, String[] stringArray, boolean bl, String string3) {
        int n = this.xCour;
        int n2 = this.yCour;
        int n3 = this.widthLabelCour;
        int n4 = this.widthGapCour;
        int n5 = this.widthTextCour;
        if (this.sensHorizontal) {
            this.xCour = n + n3 + n4 + n5 + 3;
        }
        if (this.sensVertical) {
            this.yCour = n2 + this.heightText + 3;
        }
        JLabel jLabel = new JLabel(string2);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string4 : stringArray) {
            jComboBox.addItem(string4);
        }
        this.elements.put(string, jComboBox);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!((String)jComboBox.getItemAt(i)).equals(string3)) continue;
            jComboBox.setSelectedIndex(i);
        }
        if (bl) {
            jComboBox.addActionListener(new SubmitListener(this, string));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        Font font = new Font(this.font, 1, this.tailleFonte);
        jLabel.setFont(font);
        jComboBox.setFont(font);
        if (this.autoWidth) {
            n3 = jLabel.getFontMetrics(font).stringWidth(string2) + 3;
        }
        jLabel.setBounds(0, 0, n3, this.heightText);
        jComboBox.setBounds(n3 + n4, 0, n5, this.heightText);
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        jPanel.setBounds(n, n2, n3 + n4 + n5, this.heightText);
        this.panelPP.add(jPanel);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public void addZoneText(String string, String string2, boolean bl, String string3, int n, int n2) {
        int n3 = this.xCour;
        int n4 = this.yCour;
        if (this.sensHorizontal) {
            this.xCour = n3 + n + 3;
        }
        if (this.sensVertical) {
            this.yCour = n4 + n2 + 3;
        }
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(new Font(this.font, 1, this.tailleFonte));
        jLabel.setBounds(0, 0, n, this.heightText);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(bl);
        jTextArea.setText(string3);
        jTextArea.setFont(new Font(this.font, 1, this.tailleFonte));
        this.elements.put(string, jTextArea);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBounds(0, 0 + this.heightText + 3, n, n2 - this.heightText - 3);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(n, n2 - this.heightText - 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.add(jLabel);
        jPanel.add(jScrollPane);
        jPanel.setBounds(n3, n4, n, n2);
        this.panelPP.add(jPanel);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public void addListScroll(String string, String string2, boolean bl, String[] stringArray, int n, int n2) {
        int n3 = this.xCour;
        int n4 = this.yCour;
        if (this.sensHorizontal) {
            this.xCour = n3 + n + 3;
        }
        if (this.sensVertical) {
            this.yCour = n4 + n2 + 3;
        }
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(new Font(this.font, 1, this.tailleFonte));
        jLabel.setBounds(0, 0, n, this.heightText);
        JList jList = new JList(new DefaultListModel());
        jList.setFont(new Font(this.font, 1, this.tailleFonte));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setBounds(0, 0 + this.heightText + 3, n, n2 - this.heightText - 3);
        jList.setEnabled(bl);
        Vector vector = new Vector();
        if (stringArray != null) {
            Collections.addAll(vector, stringArray);
        }
        this.elements.put(string, jList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBounds(n3, n4, n, n2);
        jList.setListData(vector);
        this.panelPP.add(jPanel);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public void setButtonFermer(String string) {
        this.buttonFermer = string;
    }

    public void addButton(String string, String string2) {
        int n = this.xCour;
        int n2 = this.yCour;
        int n3 = this.widthButtonCour;
        if (this.sensHorizontal) {
            this.xCour = n + n3 + 3;
        }
        if (this.sensVertical) {
            this.yCour = n2 + this.heightText + 3;
        }
        JButton jButton = new JButton(string2);
        Font font = new Font(this.font, 1, this.tailleFonte);
        jButton.setFont(font);
        this.elements.put(string, jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        if (this.autoWidth) {
            n3 = jButton.getFontMetrics(font).stringWidth(string2) + 20;
        }
        jButton.setBounds(n, n2, n3, this.heightText);
        jButton.setPreferredSize(new Dimension(n3, this.heightText));
        jButton.addActionListener(new SubmitListener(this, string));
        this.panelPP.add(jButton);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public void addPanel(JPanel jPanel, int n, int n2) {
        int n3 = this.xCour;
        int n4 = this.yCour;
        if (this.sensHorizontal) {
            this.xCour = n3 + n + 3;
        }
        if (this.sensVertical) {
            this.yCour = n4 + n2 + 3;
        }
        jPanel.setBounds(n3, n4, n, n2);
        this.panelPP.add(jPanel);
        this.panelPP.repaint();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public CanvasIHM addGrilleIHM(int n, int n2, int n3, ControlesCanvasIHM controlesCanvasIHM) {
        CanvasIHM canvasIHM = new CanvasIHM(n, n2, n3);
        canvasIHM.setActions(controlesCanvasIHM);
        this.addPanel(canvasIHM.getPanel(), canvasIHM.getWidth() + 30, canvasIHM.getHeight() + 30);
        return canvasIHM;
    }

    public CanvasIHM addCanvasIHM(int n, int n2, ControlesCanvasIHM controlesCanvasIHM) {
        CanvasIHM canvasIHM = new CanvasIHM(n, n2);
        canvasIHM.getPanel().setBackground(Color.yellow);
        canvasIHM.setActions(controlesCanvasIHM);
        this.addPanel(canvasIHM.getPanel(), canvasIHM.getWidth() + 30, canvasIHM.getHeight() + 30);
        return canvasIHM;
    }

    public String getValeurChamp(String string) {
        String string2 = "";
        JComponent jComponent = this.elements.get(string);
        try {
            JComponent jComponent2;
            if (jComponent instanceof JList && !((JList)(jComponent2 = (JList)jComponent)).isSelectionEmpty()) {
                string2 = (String)((JList)jComponent2).getSelectedValue();
            }
            if (jComponent instanceof JComboBox) {
                jComponent2 = (JComboBox)jComponent;
                string2 = (String)((JComboBox)jComponent2).getSelectedItem();
            } else {
                jComponent2 = (JTextComponent)jComponent;
                string2 = ((JTextComponent)jComponent2).getText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public void setValeurChamp(String string, String string2) {
        JComponent jComponent;
        JComponent jComponent2 = this.elements.get(string);
        try {
            jComponent = (JTextComponent)jComponent2;
            ((JTextComponent)jComponent).setText(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jComponent = (JComboBox)jComponent2;
            for (int i = 0; i < ((JComboBox)jComponent).getItemCount(); ++i) {
                if (!((JComboBox)jComponent).getItemAt(i).equals(string2)) continue;
                ((JComboBox)jComponent).setSelectedIndex(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setListData(String string, String[] stringArray) {
        try {
            JComponent jComponent = this.elements.get(string);
            JList jList = (JList)jComponent;
            Vector vector = new Vector();
            if (stringArray != null) {
                Collections.addAll(vector, stringArray);
            }
            jList.setListData(vector);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void desactiver(String string) throws RuntimeException {
        JComponent jComponent = this.elements.get(string);
        if (jComponent != null) {
            if (jComponent.getClass().getName().equals("javax.swing.JButton")) {
                jComponent.setEnabled(false);
            }
            if (jComponent.getClass().getName().equals("javax.swing.JTextField")) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.setEditable(false);
            }
        } else {
            throw new RuntimeException(string + " n'existe pas");
        }
    }

    public void activer(String string) throws RuntimeException {
        JComponent jComponent = this.elements.get(string);
        if (jComponent != null) {
            if (jComponent.getClass().getName().equals("javax.swing.JButton")) {
                jComponent.setEnabled(true);
            }
            if (jComponent.getClass().getName().equals("javax.swing.JTextField")) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.setEditable(true);
            }
        } else {
            throw new RuntimeException(string + " n'existe pas");
        }
    }

    public String choisirFichier(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(string));
        int n = jFileChooser.showOpenDialog(this.frame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file.getPath();
        }
        return null;
    }

    public static String[] lireFichierTexte(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new RuntimeException("Le fichier " + string + " n'existe pas ou n'est pas accessible");
            }
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            String string2 = new String(byArray);
            String string3 = string2.replaceAll("\r", "");
            String[] stringArray = string3.split("\n");
            return stringArray;
        }
        catch (Exception exception) {
            throw new RuntimeException("Erreur dans la lecture du fichier :" + string);
        }
    }

    class FormulaireWindowListener
    extends WindowAdapter {
        FormulaireWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Formulaire.this.frame.dispose();
        }
    }

    class SubmitListener
    implements ActionListener {
        private Formulaire form;
        private String nomSubmit;

        public SubmitListener(Formulaire formulaire2, String string) {
            this.form = formulaire2;
            this.nomSubmit = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (Formulaire.this.app != null) {
                    Formulaire.this.app.submit(this.form, this.nomSubmit);
                }
                if (this.nomSubmit.equals(Formulaire.this.buttonFermer)) {
                    Formulaire.this.frame.dispose();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

