//Comment trier (sort) sur plusieurs critres une collection avec ArrayList
import java.util.*;

//Classe de dfinition d'un ecollection de livre grs dans une bibliothque
// Une collection de livre est caractris par :
//   - le genre des livres (roman, bibliographie, sf , ...) une chaine
//   - le tableau de livre
//
class Livres
{
    String           genre;
    ArrayList<Livre> array;
    
    public Livres(String genre)
    {
        this.genre = genre;
        array = new ArrayList<Livre>();
    }
}

// Classe de dfinition des livres
class Livre
{
    String titre;
    String auteur;
    String ident;

    public Livre(String ident,String titre, String auteur)
    {
        this.titre  = titre;
        this.auteur = auteur;
        this.ident  = ident;
    }

    public String getTitre() {return titre;}
    public String getAuteur() {return auteur;}
    public String getIdent() {return ident;}
    
    public String toString()
    {
        return ident+"    "+titre+"      "+auteur;
    }
}
      
class CompLivreTitre implements Comparator<Livre>
{
    public int compare(Livre l1,Livre l2)
    {
        String s1 = l1.getTitre();
        String s2 = l2.getTitre();
        return( s1.compareTo(s2) );
    }
}

class CompLivreAuteur implements Comparator<Livre>
{
    public int compare(Livre l1,Livre l2)
    {
        String s1 = l1.getAuteur();
        String s2 = l2.getAuteur();
        return( s1.compareTo(s2) );
    }
}

class CompLivreIdent implements Comparator<Livre>
{
    public int compare(Livre l1,Livre l2)
    {
        String s1 = l1.getIdent();
        String s2 = l2.getIdent();
        return( s1.compareTo(s2) );
    }
}


public class Exemple12
{
    public static void main(String... a_args)
    {
        Terminal.ecrireStringln("Exemple 12");

        Livres meslivres = new Livres("sf");
        
        Livre l1 = new Livre("2012/01/001","Cavernes d'acier (Les)","Asimov Isaac");
        Livre l2 = new Livre("2012/01/002","Fleuve de l'ternit (Le)","Farmer Philip Jos");
        Livre l3 = new Livre("2012/01/003","Dune","Herbert Frank");
        Livre l4 = new Livre("2012/01/004","Robot","Asimov Isaac");
        Livre l5 = new Livre("2012/01/005","Dieux du fleuve (Les)","Farmer Philip Jos");
        
        meslivres.array.add(l1);
        meslivres.array.add(l2);
        meslivres.array.add(l3);
        meslivres.array.add(l4);
        meslivres.array.add(l5);

        for(Livre l:meslivres.array)Terminal.ecrireStringln(l+"");

        // Tri par Titre
        Terminal.ecrireStringln("------ Tri par Titre ----------------------------------------");
        Collections.sort(meslivres.array,new CompLivreTitre());
        for(Livre l:meslivres.array)Terminal.ecrireStringln(l+"");

        // Tri par Auteur
        Terminal.ecrireStringln("----- tri par Auteur -----------------------------------------");
        Collections.sort(meslivres.array,new CompLivreAuteur());
        for(Livre l:meslivres.array)Terminal.ecrireStringln(l+"");

        // Tri par Ident
        Terminal.ecrireStringln("---- tri par Ident ------------------------------------------");
        Collections.sort(meslivres.array,new CompLivreIdent());
        for(Livre l:meslivres.array)Terminal.ecrireStringln(l+"");

    }
}

