// La classe Film qui hrite de la classe MultiMedia 
//
import java.util.*;

public class Film extends MultiMedia
{
    private String   realisateur;
    private String[] acteurs;
    private String   genre;

    // Le constructeur complet qui prend en entre les attributs de la
    // classe Film mais aussi les attributs de la classe hrite
    //
    public Film(String ident,String description,String titre,
                String realisateur, String genre)
    {
        super(ident,description,titre);
        this.realisateur = realisateur;
        this.acteurs = new String[0];
        this.genre = genre;
    }

    // Ajoute un acteur
    public Film addActeur(String acteur)
    {
        ArrayList<String> l=new ArrayList<String>(Arrays.asList(acteurs));
        l.add(acteur);
        acteurs = l.toArray(acteurs);
        return this;
    }

    // Mthode qui retourne en chaine un livre et qui appelle 
    //  explicitement la mthode toString de la classe hrite 
    //  afin d'avoir les informations compltes du film et de ses 
    //  attributs hrits
    public String toString()
    {
        String a="";
        for(String s:acteurs)
            a=a+String.format("%-15s : %s\n","acteur",s);
        return 
            super.toString() + 
            String.format("%-15s : %s\n","realisateur",realisateur)+
            a +
            String.format("%-15s : %s\n","genre",genre);
    }
}
    
