// La classe Livre qui hrite de la classe MultiMedia 
//
public class Livre extends MultiMedia
{
    private String[] auteurs;
    private String   edition;
    private String   genre;
    private int      tome;

    // Le constructeur complet qui prend en entre les attributs de la
    // classe Livre mais aussi les attributs de la classe hrite
    //
    public Livre(String ident,String description,String titre,
                 String[] auteurs, String edition, String genre, int tome)
    {
        super(ident,description,titre);
        this.auteurs = auteurs;
        this.edition = edition;
        this.genre = genre;
        this.tome = tome;
    }

    // Constructeur simplifie
    public Livre(String ident,String description, String titre, 
                 String auteur)
    {
        super(ident,description,titre);
        auteurs = new String[1];
        auteurs[0] = auteur;
        this.edition = "";
        this.genre = "";
        this.tome = 0;
    }

    // Mthode qui retourne en chaine un livre et qui appelle 
    //  explicitement la mthode toString de la classe hrite 
    //  afin d'avoir les informations compltes du livre et de ses 
    //  attributs hrits
    public String toString()
    {
        String a="";
        for(String s:auteurs)
            a=a+String.format("%-15s : %s\n","auteur",s);
        return 
            super.toString() + a +
            String.format("%-15s : %s\n","edition",edition)+
            String.format("%-15s : %s\n","genre",genre)+
            String.format("%-15s : %s\n","tome",tome+"");
    }
}
    
