//Exemple du cours sur l'heritage
//
import java.util.*;

import fr.cnam.projet.*;

// Programme principal
//
public class Exemple15
{

    public static void main(String... args)
    {
        Bibliotheque biblio = new Bibliotheque();

        // Une classe qui n'herite pas de la classe abstraite MultiMedia
        MediaPrete m = new MediaPrete("un livre de Oui-oui");
        m.setDateEmprunt(avant(40));
        biblio.ajouter(m);



        System.out.println("=========================================");
        System.out.println("TOUS LES MEDIAS ============\n");
        System.out.println(biblio.getTousLesMedias());

        System.out.println("=========================================");
        System.out.println("LE CATALOGUE ============\n");
        System.out.println("------------ Les livres ------------");
        System.out.println(biblio.getCatalogue("fr.cnam.projet.Livre"));
        System.out.println("------------ Les films ------------");
        System.out.println(biblio.getCatalogue("fr.cnam.projet.Film"));
        System.out.println("------------ Les jeux  ------------");
        System.out.println(biblio.getCatalogue("fr.cnam.projet.Jeu"));
        
        System.out.println("=========================================");
        System.out.println("LES MEDIAS A RENDRE ============\n");
        // Pour tester les emprunts
        biblio.get(0).setDateEmprunt(avant(80));
        biblio.get(1).setDateEmprunt(avant(20));
        biblio.get(2).setDateEmprunt(avant(40));
        biblio.get(3).setDateEmprunt(avant(8));
        biblio.get(4).setDateEmprunt(avant(20));

        System.out.println(biblio.getMediaEmpruntDepasse());

        System.out.println("=========================================");
        System.out.println("LES MEDIAS A RENDRE ============\n");
        // Pour tester les emprunts
        biblio.get(0).setDateEmprunt(avant(10));
        biblio.get(1).setDateEmprunt(avant(10));
        biblio.get(2).setDateEmprunt(avant(10));
        biblio.get(3).setDateEmprunt(avant(10));
        biblio.get(4).setDateEmprunt(avant(10));

        System.out.println(biblio.getMediaEmpruntDepasse());
    }

    
    static Calendar avant(int jours)
    {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis( System.currentTimeMillis()-(long)jours*86400000);
        return(cal);
    }

}

