package fr.cnam.projet;

// La classe Livre qui hrite de la classe MultiMedia 
//
public class Livre extends MultiMedia
{
    private String[] auteurs;
    private String   edition;
    private String   genre;
    private int      tome;

    // Constructeur par defaut
    public Livre(){}

    // Le constructeur complet qui prend en entre les attributs de la
    // classe Livre mais aussi les attributs de la classe hrite
    //
    public Livre(String ident,String description,String titre,
                 String[] auteurs, String edition, String genre, int tome)
    {
        super(ident,description,titre);
        this.auteurs = auteurs;
        this.edition = edition;
        this.genre = genre;
        this.tome = tome;
    }

    // Mthode qui retourne en chaine un livre et qui appelle 
    //  explicitement la mthode toString de la classe hrite 
    //  afin d'avoir les informations compltes du livre et de ses 
    //  attributs hrits
    public String toString()
    {
        String a="";
        for(String s:auteurs)
            a=a+String.format("%-15s : %s\n","auteur",s);
        return 
            super.toString() + a +
            String.format("%-15s : %s\n","edition",edition)+
            String.format("%-15s : %s\n","genre",genre)+
            String.format("%-15s : %s\n","tome",tome+"");
    }

    // Duree de l'emprunt d'un livre
    //
    public int getDureeEmprunt()
    {
        if (genre.equals("roman"))
            return 60;
        if (genre.equals("magazine"))
            return 15;
        return 30;
    }
    
    // Format court d'un livre
    //
    public String formatCourt()
    {
        return titre + " de " + auteurs[0];
    }

    // Decodage
    //
    public void decoder(String ligne) throws Exception
    {
        String[] champs = ligne.split("[;]",8);
        ident = champs[1];
        if (ident.equals("")) throw new Exception("champ ident vide");
        description = champs[2];
        titre = champs[3];
        auteurs = decoderAuteurs(champs[4]);
        edition = champs[5];
        genre = champs[6];
        tome = Integer.parseInt(champs[7]);
    }

    private String[] decoderAuteurs(String auteurs)
    {
        String[] champs = auteurs.split("[/]");
        return champs;
    }
}
    
