package fr.cnam.projet;

import java.io.*;

// La classe Film qui hrite de la classe MultiMedia 
//
import java.util.*;

public class Film extends MultiMedia
{
    private String   realisateur;
    private String[] acteurs;
    private String   genre;
    private boolean  coffret;

    //Constructeur par defaut
    public Film(){}

    // Le constructeur complet qui prend en entre les attributs de la
    // classe Film mais aussi les attributs de la classe hrite
    //
    public Film(String ident,String description,String titre,
                String realisateur, String genre)
    {
        super(ident,description,titre);
        this.realisateur = realisateur;
        this.acteurs = new String[0];
        this.genre = genre;
        this.coffret = false;
    }

    // Mthode qui retourne en chaine un livre et qui appelle 
    //  explicitement la mthode toString de la classe hrite 
    //  afin d'avoir les informations compltes du film et de ses 
    //  attributs hrits
    public String toString()
    {
        String a="";
        for(String s:acteurs)
            a=a+String.format("%-15s : %s\n","acteur",s);
        return 
            super.toString() + 
            String.format("%-15s : %s\n","realisateur",realisateur)+
            String.format("%-15s : %s\n","genre",genre)+
            a +
            String.format("%-15s : %s\n","coffret",coffret+"")
            ;
    }

    // Duree de l'emprunt d'un film
    //
    public int getDureeEmprunt()
    {
        if (coffret) return 30;
        return 7;
    }

    // Format court d'un film
    //
    public String formatCourt()
    {
        return titre + " / " + genre;
    }

    // Decodage
    //
    public void decoder(String ligne) throws Exception
    {
        String[] champs = ligne.split("[;]",8);
        ident = champs[1];
        if (ident.equals("")) throw new Exception("champ ident vide");
        description = champs[2];
        titre = champs[3];
        realisateur = champs[4];
        genre = champs[5];
        acteurs = decoderActeurs(champs[6]);
        if (champs[7].equals("coffret")) coffret=true;
        else coffret=false;
    }

    private String[] decoderActeurs(String acteurs)
    {
        String[] champs = acteurs.split("[/]");
        return champs;
    }

    // Type du media
    //   utilise pour la lecture des donnees au format bianire
    //
    public String getTypeMedia()
    {
        return "FILM";
    }

    // Lecture des attributs de la classe dans un flot de Data
    //  
    public void read(DataInputStream dis) throws IOException
    {
        super.read(dis);
        realisateur = dis.readUTF();
        int nbActeurs = dis.readInt();
        acteurs = new String[nbActeurs];
        for(int i=0;i<nbActeurs;i++)
            acteurs[i]=dis.readUTF();
        genre = dis.readUTF();
        coffret = dis.readBoolean();
    }

    // Ecriture des attributs de la classe dans un flot de Data
    //
    public void write(DataOutputStream dos) throws IOException
    {
        super.write(dos);
        dos.writeUTF(realisateur);
        dos.writeInt(acteurs.length);
        for(int i =0;i<acteurs.length;i++)
            dos.writeUTF(acteurs[i]);
        dos.writeUTF(genre);
        dos.writeBoolean(coffret);
    }
}
    
