package fr.cnam.projet;

// La classe Media : class commune  tous les mdias d'uen mdiathque 
//
import java.util.*;
import java.io.*;

abstract public class MultiMedia implements Media
{
    protected String ident;          // Identification unique d'un media
    protected String description;    // Description gnrale du media
    protected String titre;          // Le titre du media
    protected int    dureeEmprunt;   // Duree de l'emprunt en jour
    protected Calendar dateEmprunt;  // date d'emprunt

    // Constructeur par defaut
    public MultiMedia(){}

    // Constructeur du media
    public MultiMedia(String ident,String description,String titre)
    {
        this.ident        = ident;
        this.description  = description;
        this.titre        = titre;
        this.dureeEmprunt = 0;
        this.dateEmprunt = null;  // Par defaut, pas d'emprunt
    }

    // Mthode qui retourne en chaine le media
    //
    public String toString()
    {
        String str = "";
        str = str + String.format("%-15s : %s\n","ident",this.ident);
        str = str + String.format("%-15s : %s\n","description",
                                  this.description);
        str = str + String.format("%-15s : %s\n","titre",
                                  this.titre);
        str = str + String.format("%-15s : %s\n","duree emprunt",
                                  this.dureeEmprunt);
        if ( this.dateEmprunt !=null)
            str = str + String.format("%-15s : %s\n","date emprunt",
                                      this.dateEmprunt.getTime());
        return str;
    }

    // Getteurs et Setteurs
    //
    public Calendar getDateEmprunt(){return dateEmprunt;}
    public void setDateEmprunt(Calendar d){dateEmprunt=d;}

    // Les methodes abstraites
    //
    // Duree de l'emprunt du media
    abstract public int    getDureeEmprunt();

    // Format court pour affichage sur 1 ligne du media
    abstract public String formatCourt();

    // Le decodage d'un media (ligne texte)
    abstract public void decoder(String ligne) throws Exception;

    // Lecture des attributs de la classe dans un flot de Data
    //
    public void read(DataInputStream dis) throws IOException
    {
        ident = dis.readUTF();
        description = dis.readUTF();
        titre = dis.readUTF();
        dureeEmprunt = dis.readInt();
        long time = dis.readLong();

        if(time==0) dateEmprunt=null;
        else
            {
                dateEmprunt = Calendar.getInstance();
                dateEmprunt.setTimeInMillis(time);
            }
    }

    // Ecriture des attributs de la classe dans un flot de Data
    //
    public void write(DataOutputStream dos) throws IOException
    {
        dos.writeUTF(ident);
        dos.writeUTF(description);
        dos.writeUTF(titre);
        dos.writeInt(dureeEmprunt);
        if (dateEmprunt==null)
            dos.writeLong(0);
        else
            dos.writeLong(dateEmprunt.getTimeInMillis());
    }
    
}

