//Exemple du cours sur l'heritage
//
import java.util.*;

import fr.cnam.projet.*;

// Programme principal
//
public class Exemple18
{

    public static void main(String... args)
    {
        try{
            
            String nomFichier=null;
            boolean importer=false;
            try{
                nomFichier = args[0];
                if (args[1].equals("importer"))
                    importer=true;
                else
                    importer=false;
            }catch(Exception ex) {
                System.out.println("Pas de nom de fichier en entree");
                System.exit(0);
            }
            
            // Creation de la bibliotheque
            //    - importer = true : lecture d'un fichier texte contenant les donnees
            //                 sous un format tabulee (espacees par des ;)
            //    - importer = false : lecture d'un fichier binaire contenant les
            //                 donnees sous un format Data
            //
            // 
            Bibliotheque biblio = new Bibliotheque(nomFichier,importer);
            
            // Sauvegarde de la bibliotheque dans un fichier bianire
            //
            biblio.sauver("../data/MEDIATHEQUE.bin");



            System.out.println("=========================================");
            System.out.println("TOUS LES MEDIAS ============\n");
            System.out.println(biblio.getTousLesMedias());
            
            System.out.println("=========================================");
            System.out.println("LE CATALOGUE ============\n");
            System.out.println("------------ Les livres ------------");
            System.out.println(biblio.getCatalogue("fr.cnam.projet.Livre"));
            System.out.println("------------ Les films ------------");
            System.out.println(biblio.getCatalogue("fr.cnam.projet.Film"));
            System.out.println("------------ Les jeux  ------------");
            System.out.println(biblio.getCatalogue("fr.cnam.projet.Jeu"));
            
            System.out.println("=========================================");
            System.out.println("LES MEDIAS A RENDRE ============\n");
            // Pour tester les emprunts
            biblio.get(0).setDateEmprunt(avant(80));
            biblio.get(1).setDateEmprunt(avant(20));
            biblio.get(2).setDateEmprunt(avant(40));
            biblio.get(3).setDateEmprunt(avant(8));
            biblio.get(4).setDateEmprunt(avant(20));
            
            System.out.println(biblio.getMediaEmpruntDepasse());
            
            System.out.println("=========================================");
            System.out.println("LES MEDIAS A RENDRE ============\n");
            // Pour tester les emprunts
            biblio.get(0).setDateEmprunt(avant(10));
            biblio.get(1).setDateEmprunt(avant(10));
            biblio.get(2).setDateEmprunt(avant(10));
            biblio.get(3).setDateEmprunt(avant(10));
            biblio.get(4).setDateEmprunt(avant(10));
            
            System.out.println(biblio.getMediaEmpruntDepasse());


        }catch(Exception ex) {
            System.out.println("Exemple17 : " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    
    static Calendar avant(int jours)
    {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis( System.currentTimeMillis()-(long)jours*86400000);
        return(cal);
    }

}

