package fr.cnam.projet;

import java.util.*;
import java.io.*;

import fr.cnam.util.*;

// Classe de gestion d'un bibliotheque de media
//
public class Bibliotheque
{
    // La collection polymorphe de  media
    private ArrayList<Media> elements;
    
    // Constructeur
    public Bibliotheque(String nomFichier,boolean importer) throws Exception
    {
        elements = new ArrayList<Media>();
        
        // Deux modes de construction de la mediateque :
        //    - importer = true : lecture d'un fichier texte contenant les donnees
        //                 sous un format tabulee (espacees par des ;)
        //    - importer = false : lecture d'un fichier binaire contenant les
        //                 donnees sous un format Data
        //
        if (importer) 
            initialiser(nomFichier);
        else
            charger("../data/MEDIATHEQUE.bin");
    }

    // Ajouter un media a la collection
    public void ajouter(Media media)
    {
        elements.add(media);
    }

    // get element
    //
    public Media get(int i){return elements.get(i);}
    
    //nb element
    public int getNb(){return elements.size();}

    // Tous les medias (pour affichage)
    public String getTousLesMedias()
    {
        String res="";
        for(Media m:elements)
            {
                res=res+"-----------------\n";
                res=res+m.toString();
            }
        return res;
    }

    // Tous les medias d'un type de media
    //
    public String getCatalogue(String typeMedia)
    {
        String res="";
        for(Media m:elements)
            if (m.getClass().getName().equals(typeMedia))
                res=res+m.formatCourt()+"\n";
        return res;
    }

    // Les medias qui doivent etre rendus
    public String getMediaEmpruntDepasse()
    {
        String res="";
        for(Media m:elements)
            {
                if ( m.getDateEmprunt() != null)
                    {
                        long d = m.getDateEmprunt().getTimeInMillis()/86400000;
                        long now = System.currentTimeMillis()/86400000;
                        if (now-d > m.getDureeEmprunt())
                            {
                                res=res+m;
                                res=res+"\n------------------\n";
                            }
                    }
            }
        return res;
    }


    // Pour ne pas etre oblige de creer des lignes fastidieuses
    //  dans le main pour creer des livres, films et jeux
    //  on lit un fichier texte qui contient pour chaque ligne
    //  un media
    //
    private void initialiser(String nomFichier) throws Exception
    {
        String[] lignes=null;
        try{
            lignes = Terminal.lireFichierTexte("../data/"+nomFichier);
        }catch(Exception ex){
            throw new Exception("Le fichier "+nomFichier+" n'existe pas dans data");
        }
            
        String erreurDecodage ="";
        try{
            int numeroLigne=1;
            for(String ligne : lignes)
                {
                    String[] type = ligne.split("[;]");
                    
                    if (type[0].equals("LIVRE"))
                        {
                            Livre l = new Livre();
                            try{
                                l.decoder(ligne);
                                ajouter(l);
                            }catch(Exception ex){
                                erreurDecodage+=numeroLigne + " : "+ex.getMessage()+"\n";
                            }
                        }
                    else if (type[0].equals("FILM"))
                        {
                            Film f = new Film();
                            try{
                                f.decoder(ligne);
                                ajouter(f);
                            }catch(Exception ex){
                                erreurDecodage+=numeroLigne + " : "+ex.getMessage()+"\n";
                            }
                        }
                    else if (type[0].equals("JEU"))
                        {
                            Jeu j = new Jeu();
                            try{
                                j.decoder(ligne);
                                ajouter(j);
                            }catch(Exception ex){
                                erreurDecodage+=numeroLigne + " : "+ex.getMessage()+"\n";
                            }
                        }
                    else
                        {
                            erreurDecodage+=numeroLigne + " : "+ "type inconnu : " +type[0]+"\n";
                        }
                    numeroLigne++;
                }//for
            
            if (!erreurDecodage.equals("")) throw new Exception("initialiser:\n"+erreurDecodage);

        }catch(Exception ex)
            {
                throw new Exception("initialiser:\n"+ex);  // Si erreur imprevue
            }
    }
    
    // Chargement en memoire de la classe Bibliotheque les donnees
    //  de la bibliotheque qui ont ete enregistrees dans un fichier
    //  binaire : format Object
    //
    public void charger(String nomFichier) throws Exception
    {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(nomFichier)));
        elements = (ArrayList<Media>)(ois.readObject());
    }

    // Sauvegarde des donnees de la mediateque dans un fichier
    //  binaire : format Object
    //
    public void sauver(String nomFichier) throws Exception
    {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(nomFichier)));
            
        oos.writeObject(elements);
    }
    

}