package fr.cnam.projet;

// La classe Film qui hrite de la classe MultiMedia 
//
import java.util.*;
import java.io.*;

public class Jeu extends MultiMedia
{
    private String   console; // Type de console (PC,PS2,PS3, ...)
    private int      ageSup;  // Limite d'age du jeu

    // Constructeur par defaut
    public Jeu(){}

    // Le constructeur complet qui prend en entre les attributs de la
    // classe Jeu mais aussi les attributs de la classe hrite
    //
    public Jeu(String ident,String description,String titre,
               String console, int ageSup)
    {
        super(ident,description,titre);
        this.console = console;
        this.ageSup  = ageSup;
    }

    // Mthode qui retourne en chaine un livre et qui appelle 
    //  explicitement la mthode toString de la classe hrite 
    //  afin d'avoir les informations compltes du film et de ses 
    //  attributs hrits
    public String toString()
    {
        return 
            super.toString() + 
            String.format("%-15s : %s\n","console",console)+
            String.format("%-15s : %s\n","ageSup",ageSup+"");
    }

    // Duree d'emprunt d'un jeu
    //
    public int getDureeEmprunt()
    {
        return 15;
    }

    // Format court d'un jeu
    //
    public String formatCourt()
    {
        return titre + " / " + console + " / " + ageSup +"ans";
    }

    // Decodage
    //
    public void decoder(String ligne) throws Exception
    {
        String[] champs = ligne.split("[;]",6);
        ident = champs[1];
        if (ident.equals("")) throw new Exception("champ ident vide");
        description = champs[2];
        titre = champs[3];
        console = champs[4];
        ageSup = Integer.parseInt(champs[5]);
    }

}
    
