//
// Importation du package d'entre sorties (Input/Output)
//  qui contient toutes les classes de gestion des fichiers
//
import java.io.*;

public class Exemple20
{
    public static void main(String[] args) throws IOException
    {
        // Ne pas confondre le caractre sparateur de rpertoire 
        //   et de fichier dans une chane qui dcrit le chemin d'accs 
        //    un fichier ou  un rpertoire : / ou \
        // Avec  le caractre sparateur des chemin d'accs se trouvant
        //   par exemple dans les variables d'environnement 
        //   PATH ou CLASSPATH.
        //
        System.out.println("----------------------");
        System.out.println("separator : "+File.separator);
        System.out.println("pathSeparator : "+File.pathSeparator);

        // On se propose de crer le rpertoire "exemple"
        //  qui contient deux sous-rpertoires "rep1" et "rep2.
        // Chacun de ces rpertoires contiennent les fichiers:
        //    f1.txt et f2.txt
        //  et rep2 contient le fichier toto.class
        //
        System.out.println("----------------------");
        File rep1 = new File("exemple"+File.separator +"rep1");
        rep1.mkdirs();
        File rep2 = new File("exemple"+File.separator +"rep2");
        rep2.mkdirs();

        File f;

        f = new File("exemple"+File.separator 
                     +"rep1"+File.separator+
                     "f1.txt");
        f.createNewFile();
        
        f = new File("exemple"+File.separator 
                     +"rep1"+File.separator+
                     "f2.txt");
        f.createNewFile();

        f = new File("exemple"+File.separator 
                     +"rep2"+File.separator+
                     "f1.txt");
        f.createNewFile();
        
        f = new File("exemple"+File.separator 
                     +"rep2"+File.separator+
                     "f2.txt");
        f.createNewFile();
        f = new File("exemple"+File.separator 
                     +"rep2"+File.separator+
                     "toto.class");
        f.createNewFile();

        // Affichage de l'arborescence cr en utilisant
        //  une mthode rcursive
        //
        // On obtient :
        //    exemple
        //      rep1
        //        f1.txt
        //        f2.txt
        //      rep2
        //        f1.txt
        //        f2.txt
        //        toto.class
        //
        afficherRep(new File("exemple"),"");

        // On affiche encore toute l'arborescence mais on filtre
        //  certains fichiers (ici les .class)
        //
        System.out.println("----------------------");
        afficherRepFiltre(new File("exemple"),"");

        // Test de la mthode qui cre un fichier temporaire.
        // Il est cr dans un rpertoire temporaire dpendant
        //  de l'OS
        //
        System.out.println("----------------------");
        f = File.createTempFile("bidon",".txt");
        System.out.println(f.getAbsolutePath());
        // C:\Temp\bidon1971705398436420305.txt
        
        // Un File en utilisant les "/" en dur
        // Attention  votre versiond de Java (>=1.5)
        //
        System.out.println("----------------------");
        f = new File("exemple/rep1/f1.txt");
        System.out.println(f.getAbsolutePath());
        if (f.exists()) System.out.println("f existe");

        // Une autre faon de faire
        //
        System.out.println("----------------------");
        f = new File(new File("exemple","rep1"),"f1.txt");
        System.out.println(f.getAbsolutePath());
        if (f.exists()) System.out.println("f existe");


        // Affichage de la variable d'environnement PATH
        //
        System.out.println("----------------------");
        String path = System.getenv("PATH");

        for(String s:System.getenv("PATH").split(File.pathSeparator))
            System.out.println(s);
    }
    
    // Mthode rcursive d'affichage d'un rpertoire
    //
    static void afficherRep(File file,String marge)
    {
        System.out.println(marge+file.getName());
        if (file.isDirectory())
            {
                for(File f:file.listFiles())
                    afficherRep(f,marge+"  ");
            }
    }

    // Mthode rcursive d'affichage d'un rpertoire
    //   et qui filtre les fichier .class (par exemple)
    //
    static void afficherRepFiltre(File file,String marge)
    {
        System.out.println(marge+file.getName());
        if (file.isDirectory())
            {
                for(File f:file.listFiles(new Filtre()))
                    afficherRepFiltre(f,marge+"  ");
            }
    }
}

// La classe qui implmente l'interface FileFilter
// et qui est utilise  l'appel de la mthode list
//
class Filtre implements FileFilter
{
    public boolean accept(File f)
    {
        String nom = f.getName();
        if (nom.endsWith(".class")) return false;
        return true;
    }
}
