//Demonstration de l'utilisation des methodes wait et notify de Java
// Deux programmes : run (excution de Exemple26)
//                   runSimple (un cas simple de synchronisation)
//
import java.util.*;

public class Exemple26 
{
    public static void main(String... args)
    {
        // Un tableau partag entre les 3 threads
        ListeTab l = new ListeTab();
        
        // Un thread qui ajoute un lment dans le tableau
        AjouterThread   t1 = new AjouterThread(l);

        // Un thread qui veut accder au premier lment du tableau
        PremierThread   t2 = new PremierThread(l);

        // Un thread qui vide le tableau puis ajoute un lment
        ViderThread t3 = new ViderThread(l);
        
        t2.start();  // GetPremier
        
        // 2 secnodes d'attente
        try{Thread.sleep(2000);}catch(Exception ex){};
        t1.start();  // Ajouter
        t3.start();  // Vider puis ajouter
        // Le vidage se fait de suite aprs l'ajout
    }
}

// La ressource partage : le tableau
//
class ListeTab
{
    private String[] tab;
    private int      index;

    public ListeTab()
    {
        tab = new String[50];
        index = 0;
    }

    synchronized void ajouter(String s) 
    {
        // Ajout
        tab[index] = s;
        index++;

        // Notification (au cas o un thread est en attente sur
        //   getPremierElementBloquant()
        //
        this.notifyAll();
        System.out.println("AJOUT>NotifyAll. Le getPremier et vider ne s'executent quand meme pas car ajouter toujours en cours"); 
        System.out.println("AJOUT> Taper une touche pour continuer...");
        Terminal.lireString();
    }

    synchronized void vider() 
    {
        index=0;
        System.out.println("SUPPR>vider la liste"); 
    }

    synchronized String getPremierElementBloquant() 
    {
        int cpt=0;
        //tant que la liste est vide
        while(index == 0) 
        {
            try {
                if(cpt>=1) System.out.println("======> BOUCLE "+cpt);
                //attente passive
                System.out.println("PREM>Wait");
                this.wait();  // attente et libre le verrou

                System.out.println("PREM>Attente de 1 seconde");
                // Pour laisser le temps  vider de s'excuter
                try{Thread.sleep(1000);}catch(Exception ex){};
                //
                cpt++;
            } catch(InterruptedException ie) {
                ie.printStackTrace();}
        }
        return tab[0];
    }
}

//================================================
class AjouterThread extends Thread
{
    private ListeTab liste;

    public AjouterThread(ListeTab liste)
    {
        this.liste=liste;
    }

    public void run()
    {
        System.out.println("AJOUT>Demarrage du thread d'ajout");
        liste.ajouter("TOTO");
    }
}

//================================================
class PremierThread extends Thread
{
    private ListeTab liste;

    public PremierThread(ListeTab liste)
    {
        this.liste=liste;
    }

    public void run()
    {
        System.out.println("PREM>Demarrage du thread de getPremier");
        String s = liste.getPremierElementBloquant();
        System.out.println("PREMIER ELEMENT: "+s);
    }
}

//================================================
class ViderThread extends Thread
{
    private ListeTab liste;

    public ViderThread(ListeTab liste)
    {
        this.liste=liste;
    }

    public void run()
    {
        System.out.println("SUPP>Demarrage du thread de vider");
        liste.vider();
        liste.ajouter("TATA");
    }
}
