// Exemple de recherche dans une collection polymorphe

import java.util.*;

public class Exemple31
{
    public static void main(String... args)
    {
        System.out.println("Execution de Exemple31");

        // Création de la liste
        ArrayList<Element> liste = new ArrayList<Element>();

        liste.add(new Individu("LAFONT","Pierre","23 rue de la pomme TOULOUSE 31130"));
        liste.add(new Individu("ABBE","Paul","12 av de la poste MONTEAU 21345"));
        liste.add(new Voiture("Peugeot","AS 234 FG"));
        liste.add(new Voiture("Citroen","DF 456 GH"));
        System.out.println( Arrays.toString(liste.toArray()) );
        
        // Rechecrhe d'une Voiture
        Voiture v = new Voiture("","AS 234 FG");
        int index = liste.indexOf(v);
        if (index!=-1) System.out.println( liste.get(index).toString() );

        // Recherche d'un Individu
        Individu i = new Individu("ABBE","Paul","");
        index = liste.indexOf(i);
        if (index!=-1) System.out.println( liste.get(index).toString() );

        // Recherche pa run objet de recherche dédié
        System.out.println( liste.indexOf(new ElementIndex("AS 234 FG")) );  // 2
        System.out.println( liste.indexOf(new ElementIndex("ABBE Paul")) );       // 1

        // Trier la collection
        Collections.sort(liste);
        System.out.println( Arrays.toString(liste.toArray()) );
        
    }
}

abstract class Element implements Comparable
{
    abstract public String getIdent();

    public boolean equals(Object o)
    {
        String e1 = this.getIdent();
        String e2 = ((Element)o).getIdent();
        return( e1.equals(e2) );
    }

    public int compareTo(Object o)
    {
        String e1 = this.getIdent();
        String e2 = ((Element)o).getIdent();
        return( e1.compareTo(e2) );
    }
}

class Individu extends Element
{
    private String nom;
    private String prenom;
    private String adresse;
    public Individu(String nom,String prenom,String adresse)
    {
        this.nom=nom;
        this.prenom=prenom;
        this.adresse=adresse;
    }

    public String getIdent()
    {
        return nom+" "+prenom;
    }

    public String toString()
    {
        return(nom+" "+prenom+" "+adresse);
    }
}

class Voiture extends Element
{
    private String marque;
    private String plaque;
    public Voiture(String marque,String plaque)
    {
        this.marque=marque;
        this.plaque=plaque;
    }

    public String getIdent()
    {
        return plaque;
    }

    public String toString()
    {
        return(marque+" "+plaque);
    }
}

class ElementIndex  extends Element
{
    private String value;
    public ElementIndex(String value)
    {this.value=value;}

    public String getIdent(){return value;}
}