// Exemple de la creation de quatres threads : deux par heritage de la classe Thread, deux autres par implementation de l'interface Runnable
public class Exemple32
{

    public static void main(String... args)
    {
        // Creation de deux threads (par heritage)
        MonThreadExtends t1 = new MonThreadExtends("A");
        MonThreadExtends t2 = new MonThreadExtends("B");

        // Creation de deux threads (par interface)
        MonThreadImplements mt3 = new MonThreadImplements("1");
        Thread t3 = new Thread(mt3);
        MonThreadImplements mt4 = new MonThreadImplements("2");
        Thread t4 = new Thread(mt4);



        // Demarrage du thread 1
        Terminal.ecrireStringln("Demarrage du Thread 1");
        t1.start();

        // Demarrage du thread 2
        Terminal.ecrireStringln("Demarrage du Thread 2");
        t2.start();

        // Demarrage du thread 3
        Terminal.ecrireStringln("Demarrage du Thread 3");
        t3.start();

        // Demarrage du thread 4
        Terminal.ecrireStringln("Demarrage du Thread 4");
        t4.start();


        // Si RC alors on arrete le thread 1
        Terminal.lireString();
        Terminal.ecrireStringln("\nArret du Thread 1");
        t1.stop = true;

        // Si RC alors on arrete le thread 2
        Terminal.lireString();
        Terminal.ecrireStringln("\nArret du Thread 2");
        t2.stop = true;

        // Si RC alors on arrete le thread 3
        Terminal.lireString();
        Terminal.ecrireStringln("\nArret du Thread 3");
        mt3.stop = true;

        // Si RC alors on arrete le thread 4
        Terminal.lireString();
        Terminal.ecrireStringln("\nArret du Thread 4");
        mt4.stop = true;
    }
}

// --------------------------------------
class MonThreadExtends extends Thread
{
    private String s;
    public boolean stop;

    public MonThreadExtends(String s)
    {
        this.s=s;
        this.stop=false;
    }

    public void run()
    {
        while(! this.stop)
            {
                System.out.print(s);
                try{Thread.sleep(200);}catch(Exception ex){};
            }
    }
}

// --------------------------------------
class MonThreadImplements implements Runnable
{
    private String s;
    public boolean stop;

    public MonThreadImplements(String s)
    {
        this.s=s;
        this.stop=false;
    }

    public void run()
    {
        while(! this.stop)
            {
                System.out.print(s);
                try{Thread.sleep(1000);}catch(Exception ex){};
            }
    }
}
