/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import java.util.HashMap;
import junit.framework.AssertionFailedError;
import org.jmock.Verifiable;
import org.jmock.builder.BuilderIdentityTable;
import org.jmock.builder.IdentityBuilder;
import org.jmock.builder.InvocationMockerBuilder;
import org.jmock.builder.InvocationMockerDescriber;
import org.jmock.builder.MatchBuilder;
import org.jmock.builder.NameMatchBuilder;
import org.jmock.core.CoreMock;
import org.jmock.core.DynamicMock;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.Stub;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Mock
implements BuilderIdentityTable,
Verifiable {
    DynamicMock coreMock;
    HashMap idTable;

    public Class getMockedType() {
        return this.coreMock.getMockedType();
    }

    public Object proxy() {
        return this.coreMock.proxy();
    }

    public String toString() {
        return this.coreMock.toString();
    }

    public void verify() {
        this.coreMock.verify();
    }

    public NameMatchBuilder stub() {
        InvocationMocker mocker = new InvocationMocker(new InvocationMockerDescriber());
        this.coreMock.addInvokable(mocker);
        return new InvocationMockerBuilder(mocker, this);
    }

    public NameMatchBuilder expect(InvocationMatcher expectation) {
        InvocationMocker mocker = new InvocationMocker(new InvocationMockerDescriber());
        mocker.addMatcher(expectation);
        this.coreMock.addInvokable(mocker);
        return new InvocationMockerBuilder(mocker, this);
    }

    public void setDefaultStub(Stub newDefaultStub) {
        this.coreMock.setDefaultStub(newDefaultStub);
    }

    public MatchBuilder lookupID(String id) {
        if (!this.idTable.containsKey(id)) {
            throw new AssertionFailedError("no expected invocation named '" + id + '\'');
        }
        return (MatchBuilder)this.idTable.get(id);
    }

    public void registerUniqueID(String id, MatchBuilder builder) {
        if (this.idTable.containsKey(id)) {
            throw new AssertionFailedError("duplicate invocation named \"" + id + '\"');
        }
        this.storeID(id, builder);
    }

    public void registerMethodName(String id, MatchBuilder builder) {
        this.storeID(id, builder);
    }

    private final void storeID(String id, IdentityBuilder builder) {
        this.idTable.put(id, builder);
    }

    private final /* synthetic */ void this() {
        this.idTable = new HashMap();
    }

    public Mock(Class mockedType) {
        this(mockedType, CoreMock.mockNameFromClass(mockedType));
    }

    public Mock(Class mockedType, String name) {
        this(new CoreMock(mockedType, name));
    }

    public Mock(DynamicMock coreMock) {
        this.this();
        this.coreMock = coreMock;
    }
}

