/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.dynamic.matcher;

import junit.framework.AssertionFailedError;
import org.jmock.dynamic.Invocation;
import org.jmock.dynamic.matcher.InvokedRecorder;
import org.jmock.dynamic.matcher.StatelessInvocationMatcher;

public class InvokedAfterMatcher
extends StatelessInvocationMatcher {
    private InvokedRecorder priorCallRecorder;
    private String priorCallDescription;

    public InvokedAfterMatcher(InvokedRecorder priorCallRecorder, String priorCallDescription) {
        this.priorCallRecorder = priorCallRecorder;
        this.priorCallDescription = priorCallDescription;
    }

    public boolean matches(Invocation invocation) {
        return this.priorCallRecorder.hasBeenInvoked();
    }

    public void invoked(Invocation invocation) {
        if (!this.matches(invocation)) {
            throw new AssertionFailedError("called out of order; should be called after " + this.priorCallDescription);
        }
    }

    public StringBuffer writeTo(StringBuffer buffer) {
        return buffer.append("after ").append(this.priorCallDescription);
    }
}

