/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.dynamic.stub;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.jmock.dynamic.Invocation;
import org.jmock.dynamic.Stub;

public class DefaultResultStub
implements Stub {
    private Map resultValuesByType = new HashMap();
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public StringBuffer writeTo(StringBuffer buf) {
        return buf.append("a guessed result");
    }

    public void addResult(Class resultType, Object resultValue) {
        this.resultValuesByType.put(resultType, resultValue);
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Class returnType = invocation.getReturnType();
        if (this.resultValuesByType.containsKey(returnType)) {
            return this.resultValuesByType.get(returnType);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        throw new AssertionFailedError(this.createErrorMessage(invocation));
    }

    public String createErrorMessage(Invocation call) {
        StringBuffer buf = new StringBuffer();
        buf.append("unexpected result type: ");
        buf.append(call.getReturnType().toString());
        buf.append("\n");
        if (this.resultValuesByType.isEmpty()) {
            buf.append("no result types are registered!");
        } else {
            buf.append("expected one of: ");
            Iterator i = this.resultValuesByType.keySet().iterator();
            buf.append(i.next().toString());
            while (i.hasNext()) {
                buf.append(", ");
                buf.append(i.next().toString());
            }
        }
        return buf.toString();
    }

    public static DefaultResultStub createStub() {
        DefaultResultStub stub = new DefaultResultStub();
        stub.addResult(Void.TYPE, null);
        stub.addResult(Byte.TYPE, new Byte(0));
        stub.addResult(Short.TYPE, new Short(0));
        stub.addResult(Integer.TYPE, new Integer(0));
        stub.addResult(Long.TYPE, new Long(0L));
        stub.addResult(Character.TYPE, new Character('\u0000'));
        stub.addResult(Float.TYPE, new Float(0.0f));
        stub.addResult(Double.TYPE, new Double(0.0));
        stub.addResult(class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultResultStub.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(0));
        stub.addResult(class$java$lang$Short == null ? (class$java$lang$Short = DefaultResultStub.class$("java.lang.Short")) : class$java$lang$Short, new Short(0));
        stub.addResult(class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultResultStub.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(0));
        stub.addResult(class$java$lang$Long == null ? (class$java$lang$Long = DefaultResultStub.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        stub.addResult(class$java$lang$Character == null ? (class$java$lang$Character = DefaultResultStub.class$("java.lang.Character")) : class$java$lang$Character, new Character('\u0000'));
        stub.addResult(class$java$lang$Float == null ? (class$java$lang$Float = DefaultResultStub.class$("java.lang.Float")) : class$java$lang$Float, new Float(0.0f));
        stub.addResult(class$java$lang$Double == null ? (class$java$lang$Double = DefaultResultStub.class$("java.lang.Double")) : class$java$lang$Double, new Double(0.0));
        stub.addResult(class$java$lang$String == null ? (class$java$lang$String = DefaultResultStub.class$("java.lang.String")) : class$java$lang$String, "<default string result>");
        return stub;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

