/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.examples.calculator;

import java.io.IOException;
import org.jmock.examples.calculator.Expression;
import org.jmock.examples.calculator.ExpressionFactory;
import org.jmock.examples.calculator.Lexer;
import org.jmock.examples.calculator.ParseException;
import org.jmock.examples.calculator.Parser;
import org.jmock.examples.calculator.SimpleExpressionFactory;
import org.jmock.examples.calculator.Token;

public class InfixParser
implements Parser {
    private ExpressionFactory factory;

    public Expression parse(String expressionString) throws ParseException {
        Lexer lexer = new Lexer(expressionString);
        try {
            return this.parseExpression(lexer);
        }
        catch (IOException ex) {
            throw new ParseException("I/O error when parsing expression", ex);
        }
    }

    private final Expression parseExpression(Lexer lexer) throws ParseException, IOException {
        return this.parseAddExpr(lexer);
    }

    private final Expression parseAddExpr(Lexer lexer) throws ParseException, IOException {
        Token token;
        Expression left = this.parseMulExpr(lexer);
        block4: while (true) {
            token = lexer.nextToken();
            switch (token.getType()) {
                case 3: {
                    left = this.factory.newAddition(left, this.parseAddExpr(lexer));
                    continue block4;
                }
                case 4: {
                    left = this.factory.newSubtraction(left, this.parseAddExpr(lexer));
                    continue block4;
                }
            }
            break;
        }
        lexer.pushBack(token);
        return left;
    }

    private final Expression parseMulExpr(Lexer lexer) throws ParseException, IOException {
        Token token;
        Expression left = this.parsePowExpr(lexer);
        block4: while (true) {
            token = lexer.nextToken();
            switch (token.getType()) {
                case 5: {
                    left = this.factory.newMultiplication(left, this.parseMulExpr(lexer));
                    continue block4;
                }
                case 6: {
                    left = this.factory.newDivision(left, this.parseMulExpr(lexer));
                    continue block4;
                }
            }
            break;
        }
        lexer.pushBack(token);
        return left;
    }

    private final Expression parsePowExpr(Lexer lexer) throws ParseException, IOException {
        Token token;
        Expression left = this.parseValExpr(lexer);
        block3: while (true) {
            token = lexer.nextToken();
            switch (token.getType()) {
                case 7: {
                    left = this.factory.newPower(left, this.parsePowExpr(lexer));
                    continue block3;
                }
            }
            break;
        }
        lexer.pushBack(token);
        return left;
    }

    private final Expression parseValExpr(Lexer lexer) throws ParseException, IOException {
        Token token = lexer.nextToken();
        switch (token.getType()) {
            case 1: {
                return this.factory.newLiteral(this.parseValue(token.getValue()));
            }
            case 2: {
                return this.factory.newVariableReference(token.getValue());
            }
            case 8: {
                Expression result = this.parseExpression(lexer);
                if (lexer.nextToken().getType() != 9) {
                    throw new ParseException("closing parenthesis missing");
                }
                return result;
            }
            case 0: {
                throw new ParseException("unexpected end of input");
            }
        }
        throw new ParseException("unexpected token \"" + token.getValue() + '\"');
    }

    public double parseValue(String valueString) throws ParseException {
        try {
            return Double.parseDouble(valueString);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("invalid number literal \"" + valueString + '\"');
        }
    }

    public InfixParser() {
        this(new SimpleExpressionFactory());
    }

    public InfixParser(ExpressionFactory factory) {
        this.factory = factory;
    }
}

