/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.jmock.core.Verifiable;
import org.jmock.util.NotImplementedException;

public class AssertMo
extends Assert {
    public static void assertEquals(String description, Object[] expectedArray, Object[] actualArray) {
        AssertMo.assertEquals((String)(description + " (different lengths)"), (int)expectedArray.length, (int)actualArray.length);
        int i = 0;
        while (i < expectedArray.length) {
            AssertMo.assertEquals((String)(description + " (element " + i + ')'), (Object)expectedArray[i], (Object)actualArray[i]);
            ++i;
        }
    }

    public static void assertExcludes(String description, String excludeString, String targetString) {
        String string = description + "\nExclude String: " + excludeString + "\n Target String: " + targetString;
        boolean bl = false;
        if (targetString.indexOf(excludeString) == -1) {
            bl = true;
        }
        AssertMo.assertTrue((String)string, (boolean)bl);
    }

    public static void assertIncludes(String description, String includeString, String targetString) {
        String string = description + "\nInclude String: " + includeString + "\n Target String: " + targetString;
        boolean bl = false;
        if (targetString.indexOf(includeString) != -1) {
            bl = true;
        }
        AssertMo.assertTrue((String)string, (boolean)bl);
    }

    public static void assertStartsWith(String description, String startString, String targetString) {
        AssertMo.assertTrue((String)(description + "\n Start String: " + startString + "\nTarget String: " + targetString), (boolean)targetString.startsWith(startString));
    }

    public static void assertVerifyFails(Verifiable aVerifiable) {
        boolean threwException = false;
        try {
            aVerifiable.verify();
        }
        catch (AssertionFailedError ex) {
            threwException = true;
        }
        AssertMo.assertTrue((String)"Should not have verified", (boolean)threwException);
    }

    protected static void failNotEquals(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + ' ';
        }
        AssertMo.fail((String)(formatted + "\nExpected:<" + expected + ">\nReceived:<" + actual + '>'));
    }

    public static void notImplemented(String mockName) {
        throw new NotImplementedException("Not Implemented in " + mockName);
    }

    public static void assertFails(String message, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        AssertMo.fail((String)message);
    }

    protected AssertMo() {
    }
}

