/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.chrono.BasicDayOfMonthDateTimeField;
import org.joda.time.chrono.BasicYearDateTimeField;
import org.joda.time.chrono.CopticEraDateTimeField;
import org.joda.time.chrono.CopticMonthOfYearDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.SkipDateTimeField;

public final class CopticChronology
extends BaseGJChronology {
    private static final long serialVersionUID = -5972804258688333942L;
    public static final int AM = 1;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final int MIN_YEAR = -292269337;
    private static final int MAX_YEAR = 292271022;
    private static final DurationField cMonthsField;
    private static final CopticChronology INSTANCE_UTC;
    private static final Map cCache;

    public static CopticChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static CopticChronology getInstance() {
        return CopticChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static CopticChronology getInstance(DateTimeZone zone) {
        return CopticChronology.getInstance(zone, 4);
    }

    public static CopticChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        CopticChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map map = cCache;
        synchronized (map) {
            CopticChronology[] chronos = (CopticChronology[])cCache.get(zone);
            if (chronos == null) {
                chronos = new CopticChronology[7];
                cCache.put(zone, chronos);
            }
            try {
                chrono = chronos[minDaysInFirstWeek - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
            }
            if (chrono == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new CopticChronology(null, null, minDaysInFirstWeek);
                    DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                    chrono = new CopticChronology(LimitChronology.getInstance(chrono, lowerLimit, null), null, minDaysInFirstWeek);
                } else {
                    chrono = CopticChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                    chrono = new CopticChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
                }
                chronos[minDaysInFirstWeek - 1] = chrono;
            }
        }
        return chrono;
    }

    CopticChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? CopticChronology.getInstanceUTC() : CopticChronology.getInstance(base.getZone());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return CopticChronology.getInstance(zone);
    }

    long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 365 && !this.isLeapYear(year)) {
            --dayOfYear;
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    long getYearDifference(long minuendInstant, long subtrahendInstant) {
        int minuendYear = this.getYear(minuendInstant);
        int subtrahendYear = this.getYear(subtrahendInstant);
        long minuendRem = minuendInstant - this.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.getYearMillis(subtrahendYear);
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    long getDateMidnightMillis(int year, int monthOfYear, int dayOfMonth) {
        FieldUtils.verifyValueBounds(DateTimeFieldType.year(), year, this.getMinYear(), this.getMaxYear());
        FieldUtils.verifyValueBounds(DateTimeFieldType.monthOfYear(), monthOfYear, 1, 13);
        FieldUtils.verifyValueBounds(DateTimeFieldType.dayOfMonth(), dayOfMonth, 1, this.getDaysInYearMonth(year, monthOfYear));
        return this.getYearMonthDayMillis(year, monthOfYear, dayOfMonth);
    }

    long getTotalMillisByYearMonth(int year, int month) {
        return (long)month * 30L * 86400000L;
    }

    int getDayOfMonth(long millis) {
        return (this.getDayOfYear(millis) - 1) % 30 + 1;
    }

    boolean isLeapYear(int year) {
        return (year & 3) == 3;
    }

    int getDaysInYearMonth(int year, int month) {
        return month != 13 ? 30 : (this.isLeapYear(year) ? 6 : 5);
    }

    int getDaysInMonthMax() {
        return 30;
    }

    int getDaysInMonthMax(int month) {
        return month != 13 ? 30 : 6;
    }

    int getMonthOfYear(long millis, int year) {
        return (int)((millis - this.getYearMillis(year)) / 30L) + 1;
    }

    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        if (year > 292271022) {
            throw new ArithmeticException("Year is too large: " + year + " > " + 292271022);
        }
        if (year < -292269337) {
            throw new ArithmeticException("Year is too small: " + year + " < " + -292269337);
        }
        int relativeYear = year - 1687;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis + 21859200000L;
    }

    int getMinYear() {
        return -292269337;
    }

    int getMaxYear() {
        return 292271022;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    long getApproxMillisAtEpoch() {
        return 53215790400000L;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new BasicYearDateTimeField(this);
            fields.years = fields.year.getDurationField();
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
            fields.era = CopticEraDateTimeField.INSTANCE;
            fields.months = cMonthsField;
            fields.monthOfYear = new CopticMonthOfYearDateTimeField(this, cMonthsField);
            fields.dayOfMonth = new BasicDayOfMonthDateTimeField(this, fields.days);
        }
    }

    static {
        cCache = new HashMap();
        cMonthsField = new PreciseDurationField(DurationFieldType.months(), 2592000000L);
        INSTANCE_UTC = CopticChronology.getInstance(DateTimeZone.UTC);
    }
}

