/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class CopticEraDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 4090856468123006167L;
    static final DateTimeField INSTANCE = new CopticEraDateTimeField();

    private CopticEraDateTimeField() {
        super(DateTimeFieldType.era());
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long instant) {
        return 1;
    }

    public long set(long instant, int era) {
        FieldUtils.verifyValueBounds(this, era, this.getMinimumValue(), this.getMaximumValue());
        return instant;
    }

    public long set(long instant, String text, Locale locale) {
        if (!"AM".equals(text)) {
            throw new IllegalFieldValueException(DateTimeFieldType.era(), text);
        }
        return instant;
    }

    public long roundFloor(long instant) {
        return Long.MIN_VALUE;
    }

    public long roundCeiling(long instant) {
        return Long.MAX_VALUE;
    }

    public long roundHalfFloor(long instant) {
        return Long.MIN_VALUE;
    }

    public long roundHalfCeiling(long instant) {
        return Long.MIN_VALUE;
    }

    public long roundHalfEven(long instant) {
        return Long.MIN_VALUE;
    }

    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 1;
    }

    public String getAsText(int fieldValue, Locale locale) {
        return "AM";
    }

    public int getMaximumTextLength(Locale locale) {
        return 2;
    }
}

