/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

final class GJMonthOfYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -4748157875845286249L;
    private static final int MIN = 1;
    private static final int MAX = 12;
    private final BaseGJChronology iChronology;

    GJMonthOfYearDateTimeField(BaseGJChronology chronology) {
        super(DateTimeFieldType.monthOfYear(), chronology.getAverageMillisPerMonth());
        this.iChronology = chronology;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long instant) {
        return this.iChronology.getMonthOfYear(instant);
    }

    public String getAsText(int fieldValue, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).monthOfYearValueToText(fieldValue);
    }

    public String getAsShortText(int fieldValue, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).monthOfYearValueToShortText(fieldValue);
    }

    public long add(long instant, int months) {
        int yearToUse;
        if (months == 0) {
            return instant;
        }
        long timePart = this.iChronology.getMillisOfDay(instant);
        int thisYear = this.iChronology.getYear(instant);
        int thisMonth = this.iChronology.getMonthOfYear(instant, thisYear);
        int monthToUse = thisMonth - 1 + months;
        if (monthToUse >= 0) {
            yearToUse = thisYear + monthToUse / 12;
            monthToUse = monthToUse % 12 + 1;
        } else {
            yearToUse = thisYear + monthToUse / 12 - 1;
            int remMonthToUse = (monthToUse = Math.abs(monthToUse)) % 12;
            if (remMonthToUse == 0) {
                remMonthToUse = 12;
            }
            if ((monthToUse = 12 - remMonthToUse + 1) == 1) {
                ++yearToUse;
            }
        }
        int dayToUse = this.iChronology.getDayOfMonth(instant, thisYear, thisMonth);
        int maxDay = this.iChronology.getDaysInYearMonth(yearToUse, monthToUse);
        if (dayToUse > maxDay) {
            dayToUse = maxDay;
        }
        long datePart = this.iChronology.getYearMonthDayMillis(yearToUse, monthToUse, dayToUse);
        return datePart + timePart;
    }

    public long add(long instant, long months) {
        int maxDay;
        long yearToUse;
        int i_months = (int)months;
        if ((long)i_months == months) {
            return this.add(instant, i_months);
        }
        long timePart = this.iChronology.getMillisOfDay(instant);
        int thisYear = this.iChronology.getYear(instant);
        int thisMonth = this.iChronology.getMonthOfYear(instant, thisYear);
        long monthToUse = (long)(thisMonth - 1) + months;
        if (monthToUse >= 0L) {
            yearToUse = (long)thisYear + monthToUse / 12L;
            monthToUse = monthToUse % 12L + 1L;
        } else {
            yearToUse = (long)thisYear + monthToUse / 12L - 1L;
            int remMonthToUse = (int)((monthToUse = Math.abs(monthToUse)) % 12L);
            if (remMonthToUse == 0) {
                remMonthToUse = 12;
            }
            if ((monthToUse = (long)(12 - remMonthToUse + 1)) == 1L) {
                ++yearToUse;
            }
        }
        if (yearToUse < (long)this.iChronology.getMinYear() || yearToUse > (long)this.iChronology.getMaxYear()) {
            throw new IllegalArgumentException("Magnitude of add amount is too large: " + months);
        }
        int i_yearToUse = (int)yearToUse;
        int i_monthToUse = (int)monthToUse;
        int dayToUse = this.iChronology.getDayOfMonth(instant, thisYear, thisMonth);
        if (dayToUse > (maxDay = this.iChronology.getDaysInYearMonth(i_yearToUse, i_monthToUse))) {
            dayToUse = maxDay;
        }
        long datePart = this.iChronology.getYearMonthDayMillis(i_yearToUse, i_monthToUse, dayToUse);
        return datePart + timePart;
    }

    public long addWrapField(long instant, int months) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), months, 1, 12));
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        long subtrahendRem;
        long minuendRem;
        int subtrahendDom;
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifference(subtrahendInstant, minuendInstant);
        }
        int minuendYear = this.iChronology.getYear(minuendInstant);
        int minuendMonth = this.iChronology.getMonthOfYear(minuendInstant, minuendYear);
        int subtrahendYear = this.iChronology.getYear(subtrahendInstant);
        int subtrahendMonth = this.iChronology.getMonthOfYear(subtrahendInstant, subtrahendYear);
        long difference = (long)(minuendYear - subtrahendYear) * 12L + (long)minuendMonth - (long)subtrahendMonth;
        int minuendDom = this.iChronology.getDayOfMonth(minuendInstant, minuendYear, minuendMonth);
        if (minuendDom == this.iChronology.getDaysInYearMonth(minuendYear, minuendMonth) && (subtrahendDom = this.iChronology.getDayOfMonth(subtrahendInstant, subtrahendYear, subtrahendMonth)) > minuendDom) {
            subtrahendInstant = this.iChronology.dayOfMonth().set(subtrahendInstant, minuendDom);
        }
        if ((minuendRem = minuendInstant - this.iChronology.getYearMonthMillis(minuendYear, minuendMonth)) < (subtrahendRem = subtrahendInstant - this.iChronology.getYearMonthMillis(subtrahendYear, subtrahendMonth))) {
            --difference;
        }
        return difference;
    }

    public long set(long instant, int month) {
        FieldUtils.verifyValueBounds(this, month, 1, 12);
        int thisYear = this.iChronology.getYear(instant);
        int thisDom = this.iChronology.getDayOfMonth(instant, thisYear);
        int maxDom = this.iChronology.getDaysInYearMonth(thisYear, month);
        if (thisDom > maxDom) {
            thisDom = maxDom;
        }
        return this.iChronology.getYearMonthDayMillis(thisYear, month, thisDom) + (long)this.iChronology.getMillisOfDay(instant);
    }

    protected int convertText(String text, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).monthOfYearTextToValue(text);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public boolean isLeap(long instant) {
        int thisYear = this.iChronology.getYear(instant);
        int thisMonth = this.iChronology.getMonthOfYear(instant, thisYear);
        if (thisMonth != 2) {
            return false;
        }
        return 29 == this.iChronology.getDaysInYearMonth(thisYear, thisMonth);
    }

    public int getLeapAmount(long instant) {
        return this.isLeap(instant) ? 1 : 0;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 12;
    }

    public int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getMonthMaxTextLength();
    }

    public int getMaximumShortTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getMonthMaxShortTextLength();
    }

    public long roundFloor(long instant) {
        int year = this.iChronology.getYear(instant);
        int month = this.iChronology.getMonthOfYear(instant, year);
        return this.iChronology.getYearMonthMillis(year, month);
    }

    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    private Object readResolve() {
        return this.iChronology.monthOfYear();
    }
}

