/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.CommonGJChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class JulianChronology
extends CommonGJChronology {
    private static final long serialVersionUID = -8731039522547897247L;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final int MIN_YEAR = -292269054;
    private static final int MAX_YEAR = 292271022;
    private static final JulianChronology INSTANCE_UTC;
    private static final Map cCache;

    static int adjustYearForSet(int year) {
        if (year <= 0) {
            if (year == 0) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)new Integer(year), null, null);
            }
            ++year;
        }
        return year;
    }

    public static JulianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static JulianChronology getInstance() {
        return JulianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static JulianChronology getInstance(DateTimeZone zone) {
        return JulianChronology.getInstance(zone, 4);
    }

    public static JulianChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        JulianChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map map = cCache;
        synchronized (map) {
            JulianChronology[] chronos = (JulianChronology[])cCache.get(zone);
            if (chronos == null) {
                chronos = new JulianChronology[7];
                cCache.put(zone, chronos);
            }
            try {
                chrono = chronos[minDaysInFirstWeek - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
            }
            if (chrono == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new JulianChronology(null, null, minDaysInFirstWeek);
                } else {
                    chrono = JulianChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                    chrono = new JulianChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
                }
                chronos[minDaysInFirstWeek - 1] = chrono;
            }
        }
        return chrono;
    }

    JulianChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? JulianChronology.getInstanceUTC() : JulianChronology.getInstance(base.getZone());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return JulianChronology.getInstance(zone);
    }

    long getDateMidnightMillis(int year, int monthOfYear, int dayOfMonth) throws IllegalArgumentException {
        return super.getDateMidnightMillis(JulianChronology.adjustYearForSet(year), monthOfYear, dayOfMonth);
    }

    boolean isLeapYear(int year) {
        return (year & 3) == 0;
    }

    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        if (year > 292271022) {
            throw new ArithmeticException("Year is too large: " + year + " > " + 292271022);
        }
        if (year < -292269054) {
            throw new ArithmeticException("Year is too small: " + year + " < " + -292269054);
        }
        int relativeYear = year - 1968;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis - 62035200000L;
    }

    int getMinYear() {
        return -292269054;
    }

    int getMaxYear() {
        return 292271022;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    long getApproxMillisAtEpoch() {
        return 62167327200000L;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
        }
    }

    static {
        cCache = new HashMap();
        INSTANCE_UTC = JulianChronology.getInstance(DateTimeZone.UTC);
    }
}

