/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;

public final class ZonedChronology
extends AssembledChronology {
    private static final long serialVersionUID = -1079258847191166848L;

    public static ZonedChronology getInstance(Chronology base, DateTimeZone zone) {
        if (base == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        if ((base = base.withUTC()) == null) {
            throw new IllegalArgumentException("UTC chronology must not be null");
        }
        if (zone == null) {
            throw new IllegalArgumentException("DateTimeZone must not be null");
        }
        return new ZonedChronology(base, zone);
    }

    static boolean useTimeArithmetic(DurationField field) {
        return field != null && field.getUnitMillis() < 43200000L;
    }

    private ZonedChronology(Chronology base, DateTimeZone zone) {
        super(base, zone);
    }

    public DateTimeZone getZone() {
        return (DateTimeZone)this.getParam();
    }

    public Chronology withUTC() {
        return this.getBase();
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getParam()) {
            return this;
        }
        if (zone == DateTimeZone.UTC) {
            return this.getBase();
        }
        return new ZonedChronology(this.getBase(), zone);
    }

    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay));
    }

    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond));
    }

    public long getDateTimeMillis(long instant, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(instant + (long)this.getZone().getOffset(instant), hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond));
    }

    private long localToUTC(long instant) {
        DateTimeZone zone = this.getZone();
        int offset = zone.getOffsetFromLocal(instant);
        if (offset != zone.getOffset(instant -= (long)offset)) {
            throw new IllegalArgumentException("Illegal instant due to time zone offset transition");
        }
        return instant;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        HashMap converted = new HashMap();
        fields.eras = this.convertField(fields.eras, converted);
        fields.centuries = this.convertField(fields.centuries, converted);
        fields.years = this.convertField(fields.years, converted);
        fields.months = this.convertField(fields.months, converted);
        fields.weekyears = this.convertField(fields.weekyears, converted);
        fields.weeks = this.convertField(fields.weeks, converted);
        fields.days = this.convertField(fields.days, converted);
        fields.halfdays = this.convertField(fields.halfdays, converted);
        fields.hours = this.convertField(fields.hours, converted);
        fields.minutes = this.convertField(fields.minutes, converted);
        fields.seconds = this.convertField(fields.seconds, converted);
        fields.millis = this.convertField(fields.millis, converted);
        fields.year = this.convertField(fields.year, converted);
        fields.yearOfEra = this.convertField(fields.yearOfEra, converted);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, converted);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, converted);
        fields.era = this.convertField(fields.era, converted);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, converted);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, converted);
        fields.dayOfYear = this.convertField(fields.dayOfYear, converted);
        fields.monthOfYear = this.convertField(fields.monthOfYear, converted);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, converted);
        fields.weekyear = this.convertField(fields.weekyear, converted);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, converted);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, converted);
        fields.millisOfDay = this.convertField(fields.millisOfDay, converted);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, converted);
        fields.secondOfDay = this.convertField(fields.secondOfDay, converted);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, converted);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, converted);
        fields.hourOfDay = this.convertField(fields.hourOfDay, converted);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, converted);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, converted);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, converted);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, converted);
    }

    private DurationField convertField(DurationField field, HashMap converted) {
        if (field == null || !field.isSupported()) {
            return field;
        }
        if (converted.containsKey(field)) {
            return (DurationField)converted.get(field);
        }
        ZonedDurationField zonedField = new ZonedDurationField(field, this.getZone());
        converted.put(field, zonedField);
        return zonedField;
    }

    private DateTimeField convertField(DateTimeField field, HashMap converted) {
        if (field == null || !field.isSupported()) {
            return field;
        }
        if (converted.containsKey(field)) {
            return (DateTimeField)converted.get(field);
        }
        ZonedDateTimeField zonedField = new ZonedDateTimeField(field, this.getZone(), this.convertField(field.getDurationField(), converted), this.convertField(field.getRangeDurationField(), converted), this.convertField(field.getLeapDurationField(), converted));
        converted.put(field, zonedField);
        return zonedField;
    }

    public String toString() {
        return "ZonedChronology[" + this.getBase() + ", " + this.getZone().getID() + ']';
    }

    static final class ZonedDateTimeField
    extends BaseDateTimeField {
        private static final long serialVersionUID = -3968986277775529794L;
        final DateTimeField iField;
        final DateTimeZone iZone;
        final DurationField iDurationField;
        final boolean iTimeField;
        final DurationField iRangeDurationField;
        final DurationField iLeapDurationField;

        ZonedDateTimeField(DateTimeField field, DateTimeZone zone, DurationField durationField, DurationField rangeDurationField, DurationField leapDurationField) {
            super(field.getType());
            if (!field.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = field;
            this.iZone = zone;
            this.iDurationField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iRangeDurationField = rangeDurationField;
            this.iLeapDurationField = leapDurationField;
        }

        public boolean isLenient() {
            return this.iField.isLenient();
        }

        public int get(long instant) {
            return this.iField.get(instant + (long)this.iZone.getOffset(instant));
        }

        public String getAsText(long instant, Locale locale) {
            return this.iField.getAsText(instant + (long)this.iZone.getOffset(instant), locale);
        }

        public String getAsShortText(long instant, Locale locale) {
            return this.iField.getAsShortText(instant + (long)this.iZone.getOffset(instant), locale);
        }

        public long add(long instant, int value) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.add(instant + (long)offset, value);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public long add(long instant, long value) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.add(instant + (long)offset, value);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public long addWrapField(long instant, int value) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.addWrapField(instant + (long)offset, value);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public long set(long instant, int value) {
            long offset = this.iZone.getOffset(instant);
            instant = this.iField.set(instant + offset, value);
            long offsetFromLocal = this.iZone.getOffsetFromLocal(instant);
            if (offset != offsetFromLocal && this.get(instant -= offsetFromLocal) != value) {
                throw new IllegalFieldValueException(this.iField.getType(), (Number)new Integer(value), null, null);
            }
            return instant;
        }

        public long set(long instant, String text, Locale locale) {
            instant = this.iField.set(instant + (long)this.iZone.getOffset(instant), text, locale);
            return instant - (long)this.iZone.getOffsetFromLocal(instant);
        }

        public int getDifference(long minuendInstant, long subtrahendInstant) {
            int offset = this.iZone.getOffset(subtrahendInstant);
            return this.iField.getDifference(minuendInstant + (this.iTimeField ? (long)offset : (long)this.iZone.getOffset(minuendInstant)), subtrahendInstant + (long)offset);
        }

        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            int offset = this.iZone.getOffset(subtrahendInstant);
            return this.iField.getDifferenceAsLong(minuendInstant + (this.iTimeField ? (long)offset : (long)this.iZone.getOffset(minuendInstant)), subtrahendInstant + (long)offset);
        }

        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public boolean isLeap(long instant) {
            return this.iField.isLeap(instant + (long)this.iZone.getOffset(instant));
        }

        public int getLeapAmount(long instant) {
            return this.iField.getLeapAmount(instant + (long)this.iZone.getOffset(instant));
        }

        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        public long roundFloor(long instant) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.roundFloor(instant + (long)offset);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public long roundCeiling(long instant) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.roundCeiling(instant + (long)offset);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public long remainder(long instant) {
            return this.iField.remainder(instant + (long)this.iZone.getOffset(instant));
        }

        public int getMinimumValue() {
            return this.iField.getMinimumValue();
        }

        public int getMinimumValue(long instant) {
            return this.iField.getMinimumValue(instant + (long)this.iZone.getOffset(instant));
        }

        public int getMaximumValue() {
            return this.iField.getMaximumValue();
        }

        public int getMaximumValue(long instant) {
            return this.iField.getMaximumValue(instant + (long)this.iZone.getOffset(instant));
        }

        public int getMaximumTextLength(Locale locale) {
            return this.iField.getMaximumTextLength(locale);
        }

        public int getMaximumShortTextLength(Locale locale) {
            return this.iField.getMaximumShortTextLength(locale);
        }
    }

    static class ZonedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -485345310999208286L;
        final DurationField iField;
        final boolean iTimeField;
        final DateTimeZone iZone;

        ZonedDurationField(DurationField field, DateTimeZone zone) {
            super(field.getType());
            if (!field.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = field;
            this.iTimeField = ZonedChronology.useTimeArithmetic(field);
            this.iZone = zone;
        }

        public boolean isPrecise() {
            return this.iTimeField ? this.iField.isPrecise() : this.iZone.isFixed();
        }

        public long getUnitMillis() {
            return this.iField.getUnitMillis();
        }

        public int getValue(long duration, long instant) {
            return this.iField.getValue(duration, instant + (long)this.iZone.getOffset(instant));
        }

        public long getValueAsLong(long duration, long instant) {
            return this.iField.getValueAsLong(duration, instant + (long)this.iZone.getOffset(instant));
        }

        public long getMillis(int value, long instant) {
            return this.iField.getMillis(value, instant + (long)this.iZone.getOffset(instant));
        }

        public long getMillis(long value, long instant) {
            return this.iField.getMillis(value, instant + (long)this.iZone.getOffset(instant));
        }

        public long add(long instant, int value) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.add(instant + (long)offset, value);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public long add(long instant, long value) {
            int offset = this.iZone.getOffset(instant);
            instant = this.iField.add(instant + (long)offset, value);
            return instant - (this.iTimeField ? (long)offset : (long)this.iZone.getOffsetFromLocal(instant));
        }

        public int getDifference(long minuendInstant, long subtrahendInstant) {
            int offset = this.iZone.getOffset(subtrahendInstant);
            return this.iField.getDifference(minuendInstant + (this.iTimeField ? (long)offset : (long)this.iZone.getOffset(minuendInstant)), subtrahendInstant + (long)offset);
        }

        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            int offset = this.iZone.getOffset(subtrahendInstant);
            return this.iField.getDifferenceAsLong(minuendInstant + (this.iTimeField ? (long)offset : (long)this.iZone.getOffset(minuendInstant)), subtrahendInstant + (long)offset);
        }
    }
}

