/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatterBuilder {
    private ArrayList iElementPairs = new ArrayList();
    private Object iFormatter;

    public DateTimeFormatter toFormatter() {
        Object f = this.getFormatter();
        DateTimePrinter printer = null;
        if (this.isPrinter(f)) {
            printer = (DateTimePrinter)f;
        }
        DateTimeParser parser = null;
        if (this.isParser(f)) {
            parser = (DateTimeParser)f;
        }
        if (printer != null || parser != null) {
            return new DateTimeFormatter(printer, parser);
        }
        throw new UnsupportedOperationException("Both printing and parsing not supported");
    }

    public DateTimePrinter toPrinter() {
        Object f = this.getFormatter();
        if (this.isPrinter(f)) {
            return (DateTimePrinter)f;
        }
        throw new UnsupportedOperationException("Printing is not supported");
    }

    public DateTimeParser toParser() {
        Object f = this.getFormatter();
        if (this.isParser(f)) {
            return (DateTimeParser)f;
        }
        throw new UnsupportedOperationException("Parsing is not supported");
    }

    public boolean canBuildFormatter() {
        return this.isFormatter(this.getFormatter());
    }

    public boolean canBuildPrinter() {
        return this.isPrinter(this.getFormatter());
    }

    public boolean canBuildParser() {
        return this.isParser(this.getFormatter());
    }

    public void clear() {
        this.iFormatter = null;
        this.iElementPairs.clear();
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        return this.append0(formatter.getPrinter(), formatter.getParser());
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer) {
        this.checkPrinter(printer);
        return this.append0(printer, null);
    }

    public DateTimeFormatterBuilder append(DateTimeParser parser) {
        this.checkParser(parser);
        return this.append0(null, parser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer, DateTimeParser parser) {
        this.checkPrinter(printer);
        this.checkParser(parser);
        return this.append0(printer, parser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer, DateTimeParser[] parsers) {
        if (printer != null) {
            this.checkPrinter(printer);
        }
        if (parsers == null) {
            throw new IllegalArgumentException("No parsers supplied");
        }
        int length = parsers.length;
        if (length == 1) {
            if (parsers[0] == null) {
                throw new IllegalArgumentException("No parser supplied");
            }
            return this.append0(printer, parsers[0]);
        }
        DateTimeParser[] copyOfParsers = new DateTimeParser[length];
        int i = 0;
        while (i < length - 1) {
            copyOfParsers[i] = parsers[i];
            if (copyOfParsers[i] == null) {
                throw new IllegalArgumentException("Incomplete parser array");
            }
            ++i;
        }
        copyOfParsers[i] = parsers[i];
        return this.append0(printer, new MatchingParser(copyOfParsers));
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeParser parser) {
        this.checkParser(parser);
        DateTimeParser[] parsers = new DateTimeParser[]{parser, null};
        return this.append0(null, new MatchingParser(parsers));
    }

    private void checkParser(DateTimeParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
    }

    private void checkPrinter(DateTimePrinter printer) {
        if (printer == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
    }

    private DateTimeFormatterBuilder append0(Object element) {
        this.iFormatter = null;
        this.iElementPairs.add(element);
        this.iElementPairs.add(element);
        return this;
    }

    private DateTimeFormatterBuilder append0(DateTimePrinter printer, DateTimeParser parser) {
        this.iFormatter = null;
        this.iElementPairs.add(printer);
        this.iElementPairs.add(parser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c) {
        return this.append0(new CharacterLiteral(c));
    }

    public DateTimeFormatterBuilder appendLiteral(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        switch (text.length()) {
            case 0: {
                return this;
            }
            case 1: {
                return this.append0(new CharacterLiteral(text.charAt(0)));
            }
        }
        return this.append0(new StringLiteral(text));
    }

    public DateTimeFormatterBuilder appendDecimal(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (maxDigits < minDigits) {
            maxDigits = minDigits;
        }
        if (minDigits < 0 || maxDigits <= 0) {
            throw new IllegalArgumentException();
        }
        if (minDigits <= 1) {
            return this.append0(new UnpaddedNumber(fieldType, maxDigits, false));
        }
        return this.append0(new PaddedNumber(fieldType, maxDigits, false, minDigits));
    }

    public DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (maxDigits < minDigits) {
            maxDigits = minDigits;
        }
        if (minDigits < 0 || maxDigits <= 0) {
            throw new IllegalArgumentException();
        }
        if (minDigits <= 1) {
            return this.append0(new UnpaddedNumber(fieldType, maxDigits, true));
        }
        return this.append0(new PaddedNumber(fieldType, maxDigits, true, minDigits));
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(fieldType, false));
    }

    public DateTimeFormatterBuilder appendShortText(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(fieldType, true));
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (maxDigits < minDigits) {
            maxDigits = minDigits;
        }
        if (minDigits < 0 || maxDigits <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(fieldType, minDigits, maxDigits));
    }

    public DateTimeFormatterBuilder appendFractionOfSecond(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendFractionOfMinute(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendFractionOfHour(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendFractionOfDay(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.dayOfYear(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendMillisOfSecond(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.millisOfSecond(), minDigits, 3);
    }

    public DateTimeFormatterBuilder appendMillisOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.millisOfDay(), minDigits, 8);
    }

    public DateTimeFormatterBuilder appendSecondOfMinute(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendSecondOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.secondOfDay(), minDigits, 5);
    }

    public DateTimeFormatterBuilder appendMinuteOfHour(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendMinuteOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.minuteOfDay(), minDigits, 4);
    }

    public DateTimeFormatterBuilder appendHourOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfDay(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendHourOfHalfday(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.hourOfHalfday(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfHalfday(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendDayOfWeek(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), minDigits, 1);
    }

    public DateTimeFormatterBuilder appendDayOfMonth(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendDayOfYear(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), minDigits, 3);
    }

    public DateTimeFormatterBuilder appendWeekOfWeekyear(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendWeekyear(int minDigits, int maxDigits) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendMonthOfYear(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendYear(int minDigits, int maxDigits) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int pivot) {
        return this.appendTwoDigitYear(pivot, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int pivot, boolean lenientParse) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.year(), pivot, lenientParse));
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int pivot) {
        return this.appendTwoDigitWeekyear(pivot, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int pivot, boolean lenientParse) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.weekyear(), pivot, lenientParse));
    }

    public DateTimeFormatterBuilder appendYearOfEra(int minDigits, int maxDigits) {
        return this.appendDecimal(DateTimeFieldType.yearOfEra(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendYearOfCentury(int minDigits, int maxDigits) {
        return this.appendDecimal(DateTimeFieldType.yearOfCentury(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendCenturyOfEra(int minDigits, int maxDigits) {
        return this.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        return this.appendText(DateTimeFieldType.halfdayOfDay());
    }

    public DateTimeFormatterBuilder appendDayOfWeekText() {
        return this.appendText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        return this.appendShortText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendMonthOfYearText() {
        return this.appendText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        return this.appendShortText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendEraText() {
        return this.appendText(DateTimeFieldType.era());
    }

    public DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZoneName(0), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        return this.append0(new TimeZoneName(1), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneId() {
        return this.append0(new TimeZoneName(2), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String zeroOffsetText, boolean showSeparators, int minFields, int maxFields) {
        return this.append0(new TimeZoneOffset(zeroOffsetText, showSeparators, minFields, maxFields));
    }

    public DateTimeFormatterBuilder appendPattern(String pattern) {
        DateTimeFormat.appendPatternTo(this, pattern);
        return this;
    }

    private Object getFormatter() {
        Object f = this.iFormatter;
        if (f == null) {
            if (this.iElementPairs.size() == 2) {
                Object printer = this.iElementPairs.get(0);
                Object parser = this.iElementPairs.get(1);
                if (printer != null) {
                    if (printer == parser || parser == null) {
                        f = printer;
                    }
                } else {
                    f = parser;
                }
            }
            if (f == null) {
                f = new Composite(this.iElementPairs);
            }
            this.iFormatter = f;
        }
        return f;
    }

    private boolean isPrinter(Object f) {
        if (f instanceof DateTimePrinter) {
            if (f instanceof Composite) {
                return ((Composite)f).isPrinter();
            }
            return true;
        }
        return false;
    }

    private boolean isParser(Object f) {
        if (f instanceof DateTimeParser) {
            if (f instanceof Composite) {
                return ((Composite)f).isParser();
            }
            return true;
        }
        return false;
    }

    private boolean isFormatter(Object f) {
        return this.isPrinter(f) || this.isParser(f);
    }

    static void appendUnknownString(StringBuffer buf, int len) {
        int i = len;
        while (--i >= 0) {
            buf.append('\ufffd');
        }
    }

    static void printUnknownString(Writer out, int len) throws IOException {
        int i = len;
        while (--i >= 0) {
            out.write(65533);
        }
    }

    static class MatchingParser
    implements DateTimeParser {
        private final DateTimeParser[] iParsers;
        private final int iParsedLengthEstimate;

        MatchingParser(DateTimeParser[] parsers) {
            this.iParsers = parsers;
            int est = 0;
            int i = parsers.length;
            while (--i >= 0) {
                int len;
                DateTimeParser parser = parsers[i];
                if (parser == null || (len = parser.estimateParsedLength()) <= est) continue;
                len = est;
            }
            this.iParsedLengthEstimate = est;
        }

        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            DateTimeParser[] parsers = this.iParsers;
            int length = parsers.length;
            Object originalState = bucket.saveState();
            boolean isOptional = false;
            int bestValidPos = position;
            Object bestValidState = null;
            int bestInvalidPos = position;
            int i = 0;
            while (i < length) {
                DateTimeParser parser = parsers[i];
                if (parser == null) {
                    if (bestValidPos <= position) {
                        return position;
                    }
                    isOptional = true;
                    break;
                }
                int parsePos = parser.parseInto(bucket, text, position);
                if (parsePos >= position) {
                    if (parsePos > bestValidPos) {
                        if (parsePos >= text.length() || i + 1 >= length || parsers[i + 1] == null) {
                            return parsePos;
                        }
                        bestValidPos = parsePos;
                        bestValidState = bucket.saveState();
                    }
                } else if (parsePos < 0 && (parsePos ^= 0xFFFFFFFF) > bestInvalidPos) {
                    bestInvalidPos = parsePos;
                }
                bucket.restoreState(originalState);
                ++i;
            }
            if (bestValidPos > position || bestValidPos == position && isOptional) {
                if (bestValidState != null) {
                    bucket.restoreState(bestValidState);
                }
                return bestValidPos;
            }
            return ~bestInvalidPos;
        }
    }

    static class Composite
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimePrinter[] iPrinters;
        private final DateTimeParser[] iParsers;
        private final int iPrintedLengthEstimate;
        private final int iParsedLengthEstimate;

        Composite(List elementPairs) {
            int i;
            int size;
            ArrayList printerList = new ArrayList();
            ArrayList parserList = new ArrayList();
            this.decompose(elementPairs, printerList, parserList);
            if (printerList.size() <= 0) {
                this.iPrinters = null;
                this.iPrintedLengthEstimate = 0;
            } else {
                size = printerList.size();
                this.iPrinters = new DateTimePrinter[size];
                int printEst = 0;
                i = 0;
                while (i < size) {
                    DateTimePrinter printer = (DateTimePrinter)printerList.get(i);
                    printEst += printer.estimatePrintedLength();
                    this.iPrinters[i] = printer;
                    ++i;
                }
                this.iPrintedLengthEstimate = printEst;
            }
            if (parserList.size() <= 0) {
                this.iParsers = null;
                this.iParsedLengthEstimate = 0;
            } else {
                size = parserList.size();
                this.iParsers = new DateTimeParser[size];
                int parseEst = 0;
                i = 0;
                while (i < size) {
                    DateTimeParser parser = (DateTimeParser)parserList.get(i);
                    parseEst += parser.estimateParsedLength();
                    this.iParsers[i] = parser;
                    ++i;
                }
                this.iParsedLengthEstimate = parseEst;
            }
        }

        public int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            DateTimePrinter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(buf, instant, chrono, displayOffset, displayZone, locale);
                ++i;
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            DateTimePrinter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(out, instant, chrono, displayOffset, displayZone, locale);
                ++i;
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            DateTimePrinter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(buf, partial, locale);
                ++i;
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            DateTimePrinter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(out, partial, locale);
                ++i;
            }
        }

        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            DateTimeParser[] elements = this.iParsers;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len && position >= 0) {
                position = elements[i].parseInto(bucket, text, position);
                ++i;
            }
            return position;
        }

        boolean isPrinter() {
            return this.iPrinters != null;
        }

        boolean isParser() {
            return this.iParsers != null;
        }

        private void decompose(List elementPairs, List printerList, List parserList) {
            int size = elementPairs.size();
            int i = 0;
            while (i < size) {
                Object element = elementPairs.get(i);
                if (element instanceof DateTimePrinter) {
                    if (element instanceof Composite) {
                        this.addArrayToList(printerList, ((Composite)element).iPrinters);
                    } else {
                        printerList.add(element);
                    }
                }
                if ((element = elementPairs.get(i + 1)) instanceof DateTimeParser) {
                    if (element instanceof Composite) {
                        this.addArrayToList(parserList, ((Composite)element).iParsers);
                    } else {
                        parserList.add(element);
                    }
                }
                i += 2;
            }
        }

        private void addArrayToList(List list, Object[] array) {
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    list.add(array[i]);
                    ++i;
                }
            }
        }
    }

    static class TimeZoneName
    implements DateTimePrinter {
        static final int LONG_NAME = 0;
        static final int SHORT_NAME = 1;
        static final int ID = 2;
        private final int iType;

        TimeZoneName(int type) {
            this.iType = type;
        }

        public int estimatePrintedLength() {
            return this.iType == 1 ? 4 : 20;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            buf.append(this.print(instant, displayZone, locale));
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            out.write(this.print(instant, displayZone, locale));
        }

        private String print(long instant, DateTimeZone displayZone, Locale locale) {
            if (displayZone == null) {
                return "";
            }
            switch (this.iType) {
                case 0: {
                    return displayZone.getName(instant, locale);
                }
                case 1: {
                    return displayZone.getShortName(instant, locale);
                }
                case 2: {
                    return displayZone.getID();
                }
            }
            return "";
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
        }
    }

    static class TimeZoneOffset
    implements DateTimePrinter,
    DateTimeParser {
        private final String iZeroOffsetText;
        private final boolean iShowSeparators;
        private final int iMinFields;
        private final int iMaxFields;

        TimeZoneOffset(String zeroOffsetText, boolean showSeparators, int minFields, int maxFields) {
            this.iZeroOffsetText = zeroOffsetText;
            this.iShowSeparators = showSeparators;
            if (minFields <= 0 || maxFields < minFields) {
                throw new IllegalArgumentException();
            }
            if (minFields > 4) {
                minFields = 4;
                maxFields = 4;
            }
            this.iMinFields = minFields;
            this.iMaxFields = maxFields;
        }

        public int estimatePrintedLength() {
            int est = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                est += this.iMinFields - 1;
            }
            if (this.iZeroOffsetText != null && this.iZeroOffsetText.length() > est) {
                est = this.iZeroOffsetText.length();
            }
            return est;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            if (displayZone == null) {
                return;
            }
            if (displayOffset == 0 && this.iZeroOffsetText != null) {
                buf.append(this.iZeroOffsetText);
                return;
            }
            if (displayOffset >= 0) {
                buf.append('+');
            } else {
                buf.append('-');
                displayOffset = -displayOffset;
            }
            int hours = displayOffset / 3600000;
            FormatUtils.appendPaddedInteger(buf, hours, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((displayOffset -= hours * 3600000) == 0 && this.iMinFields <= 1) {
                return;
            }
            int minutes = displayOffset / 60000;
            if (this.iShowSeparators) {
                buf.append(':');
            }
            FormatUtils.appendPaddedInteger(buf, minutes, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((displayOffset -= minutes * 60000) == 0 && this.iMinFields <= 2) {
                return;
            }
            int seconds = displayOffset / 1000;
            if (this.iShowSeparators) {
                buf.append(':');
            }
            FormatUtils.appendPaddedInteger(buf, seconds, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((displayOffset -= seconds * 1000) == 0 && this.iMinFields <= 3) {
                return;
            }
            if (this.iShowSeparators) {
                buf.append('.');
            }
            FormatUtils.appendPaddedInteger(buf, displayOffset, 3);
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            if (displayZone == null) {
                return;
            }
            if (displayOffset == 0 && this.iZeroOffsetText != null) {
                out.write(this.iZeroOffsetText);
                return;
            }
            if (displayOffset >= 0) {
                out.write(43);
            } else {
                out.write(45);
                displayOffset = -displayOffset;
            }
            int hours = displayOffset / 3600000;
            FormatUtils.writePaddedInteger(out, hours, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((displayOffset -= hours * 3600000) == 0 && this.iMinFields == 1) {
                return;
            }
            int minutes = displayOffset / 60000;
            if (this.iShowSeparators) {
                out.write(58);
            }
            FormatUtils.writePaddedInteger(out, minutes, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((displayOffset -= minutes * 60000) == 0 && this.iMinFields == 2) {
                return;
            }
            int seconds = displayOffset / 1000;
            if (this.iShowSeparators) {
                out.write(58);
            }
            FormatUtils.writePaddedInteger(out, seconds, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((displayOffset -= seconds * 1000) == 0 && this.iMinFields == 3) {
                return;
            }
            if (this.iShowSeparators) {
                out.write(46);
            }
            FormatUtils.writePaddedInteger(out, displayOffset, 3);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            int offset;
            boolean negative;
            block24: {
                int count;
                boolean expectSeparators;
                block28: {
                    int limit;
                    block27: {
                        block26: {
                            char c;
                            block25: {
                                limit = text.length() - position;
                                if (this.iZeroOffsetText != null) {
                                    if (this.iZeroOffsetText.length() == 0) {
                                        char c2;
                                        if (limit <= 0 || (c2 = text.charAt(position)) != '-' && c2 != '+') {
                                            bucket.setOffset(0);
                                            return position;
                                        }
                                    } else if (text.regionMatches(true, position, this.iZeroOffsetText, 0, this.iZeroOffsetText.length())) {
                                        bucket.setOffset(0);
                                        return position + this.iZeroOffsetText.length();
                                    }
                                }
                                if (limit <= 1) {
                                    return ~position;
                                }
                                c = text.charAt(position);
                                if (c == '-') {
                                    negative = true;
                                } else if (c == '+') {
                                    negative = false;
                                } else {
                                    return ~position;
                                }
                                --limit;
                                if (this.digitCount(text, ++position, 2) < 2) {
                                    return ~position;
                                }
                                int hours = FormatUtils.parseTwoDigits(text, position);
                                if (hours > 23) {
                                    return ~position;
                                }
                                offset = hours * 3600000;
                                position += 2;
                                if ((limit -= 2) <= 0) break block24;
                                c = text.charAt(position);
                                if (c != ':') break block25;
                                expectSeparators = true;
                                --limit;
                                ++position;
                                break block26;
                            }
                            if (c < '0' || c > '9') break block24;
                            expectSeparators = false;
                        }
                        count = this.digitCount(text, position, 2);
                        if (count == 0 && !expectSeparators) break block24;
                        if (count < 2) {
                            return ~position;
                        }
                        int minutes = FormatUtils.parseTwoDigits(text, position);
                        if (minutes > 59) {
                            return ~position;
                        }
                        offset += minutes * 60000;
                        position += 2;
                        if ((limit -= 2) <= 0) break block24;
                        if (!expectSeparators) break block27;
                        if (text.charAt(position) != ':') break block24;
                        --limit;
                        ++position;
                    }
                    if ((count = this.digitCount(text, position, 2)) == 0 && !expectSeparators) break block24;
                    if (count < 2) {
                        return ~position;
                    }
                    int seconds = FormatUtils.parseTwoDigits(text, position);
                    if (seconds > 59) {
                        return ~position;
                    }
                    offset += seconds * 1000;
                    position += 2;
                    if ((limit -= 2) <= 0) break block24;
                    if (!expectSeparators) break block28;
                    if (text.charAt(position) != '.' && text.charAt(position) != ',') break block24;
                    --limit;
                    ++position;
                }
                if ((count = this.digitCount(text, position, 3)) != 0 || expectSeparators) {
                    if (count < 1) {
                        return ~position;
                    }
                    offset += (text.charAt(position++) - 48) * 100;
                    if (count > 1) {
                        offset += (text.charAt(position++) - 48) * 10;
                        if (count > 2) {
                            offset += text.charAt(position++) - 48;
                        }
                    }
                }
            }
            bucket.setOffset(negative ? -offset : offset);
            return position;
        }

        private int digitCount(String text, int position, int amount) {
            int limit = Math.min(text.length() - position, amount);
            amount = 0;
            while (limit > 0) {
                char c = text.charAt(position + amount);
                if (c < '0' || c > '9') break;
                ++amount;
                --limit;
            }
            return amount;
        }
    }

    static class Fraction
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimeFieldType iFieldType;
        protected int iMinDigits;
        protected int iMaxDigits;

        protected Fraction(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
            this.iFieldType = fieldType;
            if (maxDigits > 18) {
                maxDigits = 18;
            }
            this.iMinDigits = minDigits;
            this.iMaxDigits = maxDigits;
        }

        public int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            try {
                this.printTo(buf, null, instant, chrono);
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            this.printTo(null, out, instant, chrono);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            if (partial.isSupported(this.iFieldType)) {
                long millis = partial.getChronology().set(partial, 0L);
                try {
                    this.printTo(buf, null, millis, partial.getChronology());
                }
                catch (IOException e) {}
            } else {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            if (partial.isSupported(this.iFieldType)) {
                long millis = partial.getChronology().set(partial, 0L);
                this.printTo(null, out, millis, partial.getChronology());
            } else {
                out.write(65533);
            }
        }

        /*
         * Unable to fully structure code
         */
        protected void printTo(StringBuffer buf, Writer out, long instant, Chronology chrono) throws IOException {
            block18: {
                block19: {
                    field = this.iFieldType.getField(chrono);
                    minDigits = this.iMinDigits;
                    try {
                        fraction = field.remainder(instant);
                    }
                    catch (RuntimeException e) {
                        if (buf != null) {
                            DateTimeFormatterBuilder.appendUnknownString(buf, minDigits);
                        } else {
                            DateTimeFormatterBuilder.printUnknownString(out, minDigits);
                        }
                        return;
                    }
                    if (fraction != 0L) break block18;
                    if (buf == null) ** GOTO lbl20
                    while (--minDigits >= 0) {
                        buf.append('0');
                    }
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        out.write(48);
lbl20:
                        // 2 sources

                        ** while (--minDigits >= 0)
                    }
                }
                return;
            }
            fractionData = this.getFractionData(fraction, field);
            scaled = fractionData[0];
            maxDigits = (int)fractionData[1];
            str = (scaled & 0x7FFFFFFFL) == scaled ? Integer.toString((int)scaled) : Long.toString(scaled);
            length = str.length();
            digits = maxDigits;
            while (length < digits) {
                if (buf != null) {
                    buf.append('0');
                } else {
                    out.write(48);
                }
                --minDigits;
                --digits;
            }
            if (minDigits < digits) {
                while (minDigits < digits) {
                    if (length <= 1 || str.charAt(length - 1) != '0') break;
                    --digits;
                    --length;
                }
                if (length < str.length()) {
                    if (buf != null) {
                        i = 0;
                        while (i < length) {
                            buf.append(str.charAt(i));
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < length) {
                            out.write(str.charAt(i));
                            ++i;
                        }
                    }
                    return;
                }
            }
            if (buf != null) {
                buf.append(str);
            } else {
                out.write(str);
            }
        }

        private long[] getFractionData(long fraction, DateTimeField field) {
            long scalar;
            long rangeMillis = field.getDurationField().getUnitMillis();
            int maxDigits = this.iMaxDigits;
            while (true) {
                switch (maxDigits) {
                    default: {
                        scalar = 1L;
                        break;
                    }
                    case 1: {
                        scalar = 10L;
                        break;
                    }
                    case 2: {
                        scalar = 100L;
                        break;
                    }
                    case 3: {
                        scalar = 1000L;
                        break;
                    }
                    case 4: {
                        scalar = 10000L;
                        break;
                    }
                    case 5: {
                        scalar = 100000L;
                        break;
                    }
                    case 6: {
                        scalar = 1000000L;
                        break;
                    }
                    case 7: {
                        scalar = 10000000L;
                        break;
                    }
                    case 8: {
                        scalar = 100000000L;
                        break;
                    }
                    case 9: {
                        scalar = 1000000000L;
                        break;
                    }
                    case 10: {
                        scalar = 10000000000L;
                        break;
                    }
                    case 11: {
                        scalar = 100000000000L;
                        break;
                    }
                    case 12: {
                        scalar = 1000000000000L;
                        break;
                    }
                    case 13: {
                        scalar = 10000000000000L;
                        break;
                    }
                    case 14: {
                        scalar = 100000000000000L;
                        break;
                    }
                    case 15: {
                        scalar = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        scalar = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        scalar = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        scalar = 1000000000000000000L;
                    }
                }
                if (rangeMillis * scalar / scalar == rangeMillis) break;
                --maxDigits;
            }
            return new long[]{fraction * scalar / rangeMillis, maxDigits};
        }

        public int estimateParsedLength() {
            return this.iMaxDigits;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            DateTimeField field = this.iFieldType.getField(bucket.getChronology());
            int limit = Math.min(this.iMaxDigits, text.length() - position);
            long value = 0L;
            long n = field.getDurationField().getUnitMillis() * 10L;
            int length = 0;
            while (length < limit) {
                char c = text.charAt(position + length);
                if (c < '0' || c > '9') break;
                ++length;
                long nn = n / 10L;
                value += (long)(c - 48) * nn;
                n = nn;
            }
            value /= 10L;
            if (length == 0) {
                return ~position;
            }
            if (value > Integer.MAX_VALUE) {
                return ~position;
            }
            PreciseDateTimeField parseField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, field.getDurationField());
            bucket.saveField(parseField, (int)value);
            return position + length;
        }
    }

    static class TextField
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimeFieldType iFieldType;
        private final boolean iShort;

        TextField(DateTimeFieldType fieldType, boolean isShort) {
            this.iFieldType = fieldType;
            this.iShort = isShort;
        }

        public int estimatePrintedLength() {
            return this.iShort ? 6 : 20;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            try {
                buf.append(this.print(instant, chrono, locale));
            }
            catch (RuntimeException e) {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            try {
                out.write(this.print(instant, chrono, locale));
            }
            catch (RuntimeException e) {
                out.write(65533);
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            try {
                buf.append(this.print(partial, locale));
            }
            catch (RuntimeException e) {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            try {
                out.write(this.print(partial, locale));
            }
            catch (RuntimeException e) {
                out.write(65533);
            }
        }

        private String print(long instant, Chronology chrono, Locale locale) {
            DateTimeField field = this.iFieldType.getField(chrono);
            if (this.iShort) {
                return field.getAsShortText(instant, locale);
            }
            return field.getAsText(instant, locale);
        }

        private String print(ReadablePartial partial, Locale locale) {
            if (partial.isSupported(this.iFieldType)) {
                DateTimeField field = this.iFieldType.getField(partial.getChronology());
                if (this.iShort) {
                    return field.getAsShortText(partial, locale);
                }
                return field.getAsText(partial, locale);
            }
            return "\ufffd";
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            int limit = text.length();
            int i = position;
            while (i < limit) {
                char c = text.charAt(i);
                if (c < 'A' || !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && !Character.isLetter(c)) break;
                ++i;
            }
            if (i == position) {
                return ~position;
            }
            Locale locale = bucket.getLocale();
            bucket.saveField(this.iFieldType, text.substring(position, i), locale);
            return i;
        }
    }

    static class TwoDigitYear
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimeFieldType iType;
        private final int iPivot;
        private final boolean iLenientParse;

        TwoDigitYear(DateTimeFieldType type, int pivot, boolean lenientParse) {
            this.iType = type;
            this.iPivot = pivot;
            this.iLenientParse = lenientParse;
        }

        public int estimateParsedLength() {
            return this.iLenientParse ? 4 : 2;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            int low;
            char c;
            int limit = text.length() - position;
            if (!this.iLenientParse) {
                if ((limit = Math.min(2, limit)) < 2) {
                    return ~position;
                }
            } else {
                boolean hasSignChar = false;
                boolean negative = false;
                int length = 0;
                while (length < limit) {
                    char c2 = text.charAt(position + length);
                    if (length == 0 && (c2 == '-' || c2 == '+')) {
                        hasSignChar = true;
                        boolean bl = negative = c2 == '-';
                        if (negative) {
                            ++length;
                            continue;
                        }
                        ++position;
                        --limit;
                        continue;
                    }
                    if (c2 < '0' || c2 > '9') break;
                    ++length;
                }
                if (length == 0) {
                    return ~position;
                }
                if (hasSignChar || length != 2) {
                    int value;
                    if (length >= 9) {
                        value = Integer.parseInt(text.substring(position, position += length));
                    } else {
                        int i = position;
                        if (negative) {
                            ++i;
                        }
                        try {
                            value = text.charAt(i++) - 48;
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            return ~position;
                        }
                        position += length;
                        while (i < position) {
                            value = (value << 3) + (value << 1) + text.charAt(i++) - 48;
                        }
                        if (negative) {
                            value = -value;
                        }
                    }
                    bucket.saveField(this.iType, value);
                    return position;
                }
            }
            if ((c = text.charAt(position)) < '0' || c > '9') {
                return ~position;
            }
            int year = c - 48;
            c = text.charAt(position + 1);
            if (c < '0' || c > '9') {
                return ~position;
            }
            year = (year << 3) + (year << 1) + c - 48;
            int pivot = this.iPivot;
            if (bucket.getPivotYear() != null) {
                pivot = bucket.getPivotYear();
            }
            int t = (low = pivot - 50) >= 0 ? low % 100 : 99 + (low + 1) % 100;
            bucket.saveField(this.iType, year += low + (year < t ? 100 : 0) - t);
            return position + 2;
        }

        public int estimatePrintedLength() {
            return 2;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            int year = this.getTwoDigitYear(instant, chrono);
            if (year < 0) {
                buf.append('\ufffd');
                buf.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(buf, year, 2);
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            int year = this.getTwoDigitYear(instant, chrono);
            if (year < 0) {
                out.write(65533);
                out.write(65533);
            } else {
                FormatUtils.writePaddedInteger(out, year, 2);
            }
        }

        private int getTwoDigitYear(long instant, Chronology chrono) {
            try {
                int year = this.iType.getField(chrono).get(instant);
                if (year < 0) {
                    year = -year;
                }
                return year % 100;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            int year = this.getTwoDigitYear(partial);
            if (year < 0) {
                buf.append('\ufffd');
                buf.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(buf, year, 2);
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            int year = this.getTwoDigitYear(partial);
            if (year < 0) {
                out.write(65533);
                out.write(65533);
            } else {
                FormatUtils.writePaddedInteger(out, year, 2);
            }
        }

        private int getTwoDigitYear(ReadablePartial partial) {
            if (partial.isSupported(this.iType)) {
                try {
                    int year = partial.get(this.iType);
                    if (year < 0) {
                        year = -year;
                    }
                    return year % 100;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        protected final int iMinPrintedDigits;

        protected PaddedNumber(DateTimeFieldType fieldType, int maxParsedDigits, boolean signed, int minPrintedDigits) {
            super(fieldType, maxParsedDigits, signed);
            this.iMinPrintedDigits = minPrintedDigits;
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            try {
                DateTimeField field = this.iFieldType.getField(chrono);
                FormatUtils.appendPaddedInteger(buf, field.get(instant), this.iMinPrintedDigits);
            }
            catch (RuntimeException e) {
                DateTimeFormatterBuilder.appendUnknownString(buf, this.iMinPrintedDigits);
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            try {
                DateTimeField field = this.iFieldType.getField(chrono);
                FormatUtils.writePaddedInteger(out, field.get(instant), this.iMinPrintedDigits);
            }
            catch (RuntimeException e) {
                DateTimeFormatterBuilder.printUnknownString(out, this.iMinPrintedDigits);
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendPaddedInteger(buf, partial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException e) {
                    DateTimeFormatterBuilder.appendUnknownString(buf, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.appendUnknownString(buf, this.iMinPrintedDigits);
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writePaddedInteger(out, partial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException e) {
                    DateTimeFormatterBuilder.printUnknownString(out, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.printUnknownString(out, this.iMinPrintedDigits);
            }
        }
    }

    static class UnpaddedNumber
    extends NumberFormatter {
        protected UnpaddedNumber(DateTimeFieldType fieldType, int maxParsedDigits, boolean signed) {
            super(fieldType, maxParsedDigits, signed);
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            try {
                DateTimeField field = this.iFieldType.getField(chrono);
                FormatUtils.appendUnpaddedInteger(buf, field.get(instant));
            }
            catch (RuntimeException e) {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            try {
                DateTimeField field = this.iFieldType.getField(chrono);
                FormatUtils.writeUnpaddedInteger(out, field.get(instant));
            }
            catch (RuntimeException e) {
                out.write(65533);
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendUnpaddedInteger(buf, partial.get(this.iFieldType));
                }
                catch (RuntimeException e) {
                    buf.append('\ufffd');
                }
            } else {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writeUnpaddedInteger(out, partial.get(this.iFieldType));
                }
                catch (RuntimeException e) {
                    out.write(65533);
                }
            } else {
                out.write(65533);
            }
        }
    }

    static abstract class NumberFormatter
    implements DateTimePrinter,
    DateTimeParser {
        protected final DateTimeFieldType iFieldType;
        protected final int iMaxParsedDigits;
        protected final boolean iSigned;

        NumberFormatter(DateTimeFieldType fieldType, int maxParsedDigits, boolean signed) {
            this.iFieldType = fieldType;
            this.iMaxParsedDigits = maxParsedDigits;
            this.iSigned = signed;
        }

        public int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            int value;
            int limit = Math.min(this.iMaxParsedDigits, text.length() - position);
            boolean negative = false;
            int length = 0;
            while (length < limit) {
                char c = text.charAt(position + length);
                if (length == 0 && (c == '-' || c == '+') && this.iSigned) {
                    boolean bl = negative = c == '-';
                    if (length + 1 >= limit || (c = text.charAt(position + length + 1)) < '0' || c > '9') break;
                    if (negative) {
                        ++length;
                    } else {
                        ++position;
                    }
                    limit = Math.min(limit + 1, text.length() - position);
                    continue;
                }
                if (c < '0' || c > '9') break;
                ++length;
            }
            if (length == 0) {
                return ~position;
            }
            if (length >= 9) {
                value = Integer.parseInt(text.substring(position, position += length));
            } else {
                int i = position;
                if (negative) {
                    ++i;
                }
                try {
                    value = text.charAt(i++) - 48;
                }
                catch (StringIndexOutOfBoundsException e) {
                    return ~position;
                }
                position += length;
                while (i < position) {
                    value = (value << 3) + (value << 1) + text.charAt(i++) - 48;
                }
                if (negative) {
                    value = -value;
                }
            }
            bucket.saveField(this.iFieldType, value);
            return position;
        }

        public abstract void printTo(Writer var1, ReadablePartial var2, Locale var3) throws IOException;

        public abstract void printTo(StringBuffer var1, ReadablePartial var2, Locale var3);

        public abstract void printTo(Writer var1, long var2, Chronology var4, int var5, DateTimeZone var6, Locale var7) throws IOException;

        public abstract void printTo(StringBuffer var1, long var2, Chronology var4, int var5, DateTimeZone var6, Locale var7);

        public abstract int estimatePrintedLength();
    }

    static class StringLiteral
    implements DateTimePrinter,
    DateTimeParser {
        private final String iValue;

        StringLiteral(String value) {
            this.iValue = value;
        }

        public int estimatePrintedLength() {
            return this.iValue.length();
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            buf.append(this.iValue);
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            out.write(this.iValue);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            buf.append(this.iValue);
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            out.write(this.iValue);
        }

        public int estimateParsedLength() {
            return this.iValue.length();
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            if (text.regionMatches(true, position, this.iValue, 0, this.iValue.length())) {
                return position + this.iValue.length();
            }
            return ~position;
        }
    }

    static class CharacterLiteral
    implements DateTimePrinter,
    DateTimeParser {
        private final char iValue;

        CharacterLiteral(char value) {
            this.iValue = value;
        }

        public int estimatePrintedLength() {
            return 1;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            buf.append(this.iValue);
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            out.write(this.iValue);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            buf.append(this.iValue);
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            out.write(this.iValue);
        }

        public int estimateParsedLength() {
            return 1;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            char b;
            if (position >= text.length()) {
                return ~position;
            }
            char a = text.charAt(position);
            if (a != (b = this.iValue) && (a = Character.toUpperCase(a)) != (b = Character.toUpperCase(b)) && (a = Character.toLowerCase(a)) != (b = Character.toLowerCase(b))) {
                return ~position;
            }
            return position + 1;
        }
    }
}

