// ATELIER 5  CAS 3
// Client.java
//
import java.awt.*;
import java.io.*;
import java.net.*;
import java.beans.*;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.*;
import com.thoughtworks.xstream.converters.reflection.*;

public class Client
{
		static public void main(String args[]) throws Exception
		{
				/* Creation du socket sur le port du serveur */
				Socket soc = new Socket(InetAddress.getLocalHost(),9999);
				
				/* Creation des canaux d'ecriture et de lecture du socket */
				OutputStream os    = soc.getOutputStream();
				InputStream  is    = soc.getInputStream();
				PrintStream  ps    = new PrintStream(os);
				BufferedReader br  = new BufferedReader(new InputStreamReader(is));

				/*
					Le client va ecrire cycliquement deux informations :
					- une chaine de caractre quelconque
					- un objet (de classe Individu) transform en XML et crit sous la forme d'une chane 
					de caractre
					Ainsi, le client et le serveur ne communiquent sur le socket que sous la
							 forme de flux de chine de caractre.
							 
					Aprs chaque criture, le client attend une rponse de la part du serveur.
					L'information reue est un objet Java (de classe Individu)
				*/
				
				int n=0;  // On numrote chaque envoi (est l'age de l'individu ecrit sur le socket)

				XStream xstream = new XStream(new DomDriver());
				////XStream xstream = new XStream(new XppDriver());

				while(true){
						try{
								// ----------------------------------------------------------------------------

								// Ecriture de la 1ere information : une chaine qcq
								//
								ps.println("1234567890");
								ps.flush();

								// Ecriture de la 2eme information : l'individu
								// On convertit l'individu en XML sous la forme d'une
								// chaine de caractere
								//
								Individu ind = new Individu("AAA","BBB",n++);
								//
								String indXmlStr = xstream.toXML(ind);
								//
								// On ecrit l'individu en XML comme une chaine de caractere
								//
								indXmlStr = indXmlStr.replaceAll("\n","");
								ps.println(indXmlStr);
								ps.flush();

								// ----------------------------------------------------------------------------
								// Lecture de la rponse du serveur (on attend un individu sous la forme
								//  d'un flux XML
								indXmlStr = br.readLine();  // Lecture de la chaine
								//
								// Conversion de la chaine XML en Individu
								Object obj = (Object) xstream.fromXML(indXmlStr);
								Individu ind2 = (Individu)(obj);

								// On ecrit la reponse  l'cran
								//
								System.out.println(ind2.toString());

								// On attend 1/2 seconde unquemment pour le confort visuel du deroulement
								//  du programme
								try{Thread.sleep(500);}catch(Exception e){}
								
						}catch(Exception e){System.out.println(e);}

				}
				///soc.close();  // La boucle etant infinie on ne peut pas fermer le socket
		}
}

