package fr.cnam.ihm;

import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.util.*;

/**
   Classe de dfinition d'un formulaire JAVA permettant de faire  
   minima une IHM Java pour saisir des informations et faire des 
   actions via des boutons.<BR>
   Pour cela, il faut que l'applicatif implmente les mthodes de 
   l'interface FormulaireInt.<BR><BR>
*/
public class Formulaire
{
    private FormulaireInt             app;
    private JFrame                    frame;
    private int                       widthFrame;
    private int                       heightFrame;
    private JPanel                    panelPP;
    private ArrayList<JButton>        buttons;
    private boolean                   synchrone;
    private String                    buttonFermer;
    private Exception                 exceptionForm;
    private int                       xCour;
    private int                       yCour;
    private int                       widthLabelCour;
    private int                       widthGapCour;
    private int                       widthTextCour;
    private int                       widthButtonCour;
    private int                       widthZoneCour;
    private String                    font;        

    private static int tailleFonte  = 11;
    private static int heightText   = 20;

    /*  Verrou de synchronisation pour tre synchrone
       sur l'affichage d'un formulaire */
    private Integer verrou;

    // Les lments IHM du formulaire
    Hashtable<String,JComponent>  elements;
    
    /**
       Constructeur d'un formulaire.<br>
       @param titre Titre affich dans le bandeau de la fenetre
       @param app Un objet dont la classe implmente l'interface FormualaireInt
       @param synchrone l'excution est synchrone si true
       @param width longueur du formulaire
       @param height hauteur du formulaire
    */
    public Formulaire(String titre, 
                      FormulaireInt app,
                      boolean synchrone,
                      int width,
                      int height)
    {
        this.app             = app;
        this.frame           = new JFrame(titre);
        this.widthFrame      = width;
        this.heightFrame     = height;
        this.synchrone       = synchrone;
        this.buttonFermer    = "";
        this.font            = "Courier";
        
        this.panelPP     = new JPanel();
        this.panelPP.setLayout(null);

        this.frame.add(panelPP);
        this.frame.addWindowListener(new FormulaireWindowListener());

        this.xCour           = 0;
        this.yCour           = 0;
        this.widthLabelCour  = 100;
        this.widthGapCour    = 0;
        this.widthTextCour   = 100;
        this.widthButtonCour = 100;
        this.widthZoneCour   = 200;

        this.verrou = new Integer(0);

        this.elements = new Hashtable<String,JComponent>();
    }

    /** Initialise l'applicatif.<br>Cette mthode est utilise dans le cas o quand on cre le formulaire on ne connait pas encore l'applicatif qui gre le formulaire. On appelle alors cette mthode pour initialiser l'applicatif du formulaire.
        @param app Un objet qui implmente l'interface Formulaireint */
    public void setApp(FormulaireInt app)
    {
        this.app = app;
    }

    /** Retourne la position courante en X de la position des lments
        @return int la valeur X */
    public int getXCour(){return xCour;}

    /** Retourne la position courante en Y de la position des lments
        @return int la valeur Y */
    public int getYCour(){return yCour;}

    /** Affichage du formulaire.<br>
     Cette mthode peut tre synhrone (voir le parametre synhrone  la cration du formulaire.
    */
    public void afficher() throws FormulaireException
    {
        this.frame.setPreferredSize(new Dimension(this.widthFrame+15,this.heightFrame+40));
        this.frame.pack();
        this.frame.show();
        if (this.synchrone) 
            {
                attendre();
                if (exceptionForm!=null)
                    {
                        Exception ex = exceptionForm;
                        exceptionForm = null;
                        throw new FormulaireException(ex);
                    }
            }
    }

    /** Affichage du formulaire en x,y de l'ecran */
    public void afficher(int x,int y) throws FormulaireException
    {
        this.frame.setLocation(x,y);
        afficher();
    }

    /** Permet de fermer le formulaire
     */
    public void fermer()
    {
        frame.dispose();
        if (synchrone) debloquer();
    }


    /** Ajout dans le formulaire un label.<br>
        Valeur -1 implique prend la valeur prcdente et comportement par dfaut de positionnement 
        @param label Chaine qui prcde la zone de saisie
        @param xChamp coordonne du champ (ou -1)
        @param yChamp coordonne du champ (ou -1)
        @param widthLabel longueur du label du champ (ou -1)
    */
    public void addLabel(String label,
                         int xChamp, 
                         int yChamp,
                         int widthLabel)
    {
        if (xChamp==-1) xChamp=this.xCour;
        if (yChamp==-1) yChamp=this.yCour;
        if (widthLabel==-1) widthLabel=this.widthLabelCour;
        
        this.xCour=xChamp;
        this.yCour=yChamp+this.heightText+3;
        this.widthLabelCour=widthLabel;

        JLabel l = new JLabel(label);

        JPanel p = new JPanel();
        p.setLayout(null);
        l.setFont(new Font(font,Font.BOLD,tailleFonte));
        l.setBounds(0,0,widthLabel,this.heightText);

        p.add(l);

        p.setBounds(xChamp,yChamp,widthLabel,this.heightText);

        this.panelPP.add(p);
        this.panelPP.repaint();
        this.frame.repaint();
    }
    


    /** Ajout dans le formulaire d'un texte de saisie compos d'un label 
        et d'une zone de saisie.<br>
        Valeur -1 implique prend la valeur prcdente et comportement par dfaut de positionnement 
        @param nom Le nom du champ
        @param label Chaine qui prcde la zone de saisie
        @param editable dtermine si la zone de saisie est ditable 
        @param value valeur initiale dans la zone de saisie
        @param xChamp coordonne du champ (ou -1)
        @param yChamp coordonne du champ (ou -1)
        @param widthLabel longueur du label du champ (ou -1)
        @param widthGap espace entre le label et le texte de saisi (ou -1)
        @param widthText longueur du texte de saisi (ou -1)
    */
    public void addText(String nom,
                        String label,
                        boolean editable,
                        String value,
                        int xChamp, 
                        int yChamp,
                        int widthLabel,
                        int widthGap, 
                        int widthText)
    {
        if (xChamp==-1) xChamp=this.xCour;
        if (yChamp==-1) yChamp=this.yCour;
        if (widthLabel==-1) widthLabel=this.widthLabelCour;
        if (widthGap==-1) widthGap=this.widthGapCour;
        if (widthText==-1) widthText=this.widthTextCour;
        
        this.xCour=xChamp;
        this.yCour=yChamp+this.heightText+3;
        this.widthLabelCour=widthLabel;
        this.widthGapCour=widthGap;
        this.widthTextCour=widthText;
        

        JLabel l = new JLabel(label);
        JTextField tf = new JTextField();
        tf.setEditable(editable);
        tf.setText(value);
        elements.put(nom,tf);
        

        JPanel p = new JPanel();
        p.setLayout(null);
        l.setFont(new Font(font,Font.BOLD,tailleFonte));
        tf.setFont(new Font(font,Font.BOLD,tailleFonte));

        l.setBounds(0,0,widthLabel,this.heightText);
        tf.setBounds(widthLabel+widthGap,0,widthText,this.heightText);

        p.add(l);
        p.add(tf);

        p.setBounds(xChamp,yChamp,widthLabel+widthGap+widthText,this.heightText);

        this.panelPP.add(p);
        this.panelPP.repaint();
        this.frame.repaint();
    }
    
    /** Ajout dans le formulaire d'un texte de saisie compos d'un 
        label et d'une zone de saisie.
        @param nom Le nom du champ
        @param label Chaine qui prcde la zone de saisie
        @param editable dtermine si la zone de saisie est ditable 
    */
    public void addText(String nom,
                        String label,
                        boolean editable)
    {
        addText(nom,label,editable,"",-1,-1,-1,-1,-1);
    }

    /** Ajout dans le formulaire d'un texte de saisie compos d'un 
        label et d'une zone de saisie.
        @param nom Le nom du champ
        @param label Chaine qui prcde la zone de saisie
        @param editable dtermine si la zone de saisie est ditable 
    */
    public void addText(String nom,
                        String label,
                        boolean editable,
                        String value)
    {
        addText(nom,label,editable,value,
                this.xCour,
                this.yCour,
                this.widthLabelCour,
                this.widthGapCour,
                this.widthTextCour);
    }

    /** Ajout dans le formulaire d'un texte de saisie compos d'un label 
        et d'une zone de saisie.<br>
        Valeur -1 implique prend la valeur prcdente.
        @param nom Le nom du champ
        @param label Chaine qui prcde la zone de saisie
        @param editable dtermine si la zone de saisie est ditable 
        @param value valeur initiale dans la zone de saisie 
        @param xChamp coordonne du champ (ou -1)
        @param yChamp coordonne du champ (ou -1)
        @param width longueur de la zone de texte (ou -1)
        @param height hauteur de la zone de texte
    */
    public void addZoneText(String nom,
                            String label,
                            boolean editable,
                            String value,
                            int xChamp, 
                            int yChamp,
                            int width,
                            int height)
    {
        if (xChamp==-1) xChamp=this.xCour;
        if (yChamp==-1) yChamp=this.yCour;
        if (width==-1)  width=this.widthZoneCour;

        this.xCour=xChamp;
        this.yCour=yChamp+this.heightText+height+3;
        this.widthZoneCour=width;
        
        
        JLabel l = new JLabel(label);
        l.setFont(new Font(font,Font.BOLD,tailleFonte));
        l.setBounds(0,0,width,this.heightText);

        JTextArea tf = new JTextArea();
        tf.setEditable(editable);
        tf.setText(value);
        tf.setFont(new Font(font,Font.BOLD,tailleFonte));

        elements.put(nom,tf);

        JScrollPane scrollbar = new JScrollPane(tf);
        scrollbar.setBounds(0,0+this.heightText+3,width,height-this.heightText-3);
        scrollbar.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS); 
        scrollbar.setPreferredSize(new Dimension(width,height-this.heightText-3));

        JPanel p = new JPanel();
        p.setLayout(null);

        p.add(l);
        p.add(scrollbar);
        
        p.setBounds(xChamp,yChamp,width,height);

        this.panelPP.add(p);
        this.panelPP.repaint();
        this.frame.repaint();
    }
    
    /** Ajout dans le formulaire d'une liste scrollable de valeurs.<br>
        Valeur -1 implique prend la valeur prcdente.
        @param nom Le nom de la liste scrollable
        @param titre Titre qui prcde la liste
        @param editable dtermine si la zone de saisie est ditable 
        @param value valeur initiale dans la zone de saisie 
        @param xChamp coordonne du coin haut gauche  (ou -1)
        @param yChamp coordonne du coin au gauche (ou -1)
        @param width longueur de la zone (ou -1)
        @param height hauteur de la zone 
    */
    public void addListScroll(String nom,
                              String titre,
                              boolean editable,
                              String[] values,
                              int xChamp, 
                              int yChamp,
                              int width,
                              int height)
    {
        if (xChamp==-1) xChamp=this.xCour;
        if (yChamp==-1) yChamp=this.yCour;
        if (width==-1)  width=this.widthZoneCour;

        this.xCour=xChamp;
        this.yCour=yChamp+this.heightText+height+3;
        this.widthZoneCour=width;
        
        JLabel titrel = new JLabel(titre);
        JList liste = new JList(new DefaultListModel());
        JScrollPane scroll = new JScrollPane(liste);
        liste.setFont(new Font(font,Font.BOLD,tailleFonte));

        liste.setEnabled(editable);
        Vector<String> v = new Vector<String>();
        if (values!=null)
            Collections.addAll(v,values);

        elements.put(nom,liste);


        JPanel p = new JPanel(new BorderLayout());
        p.add(titrel,BorderLayout.NORTH);
        p.add(scroll,BorderLayout.CENTER);

        p.setBounds(xChamp,yChamp,width,height);

        liste.setListData(v);

        this.panelPP.add(p);
        this.panelPP.repaint();
        this.frame.repaint();
    }
    
    /** Designe le bouton qui ferme la fenetre et debloque si synchrone
        @param nomButton le nom du bouton
     */
    public void setButtonFermer(String nomButton)
    {
        this.buttonFermer = nomButton;
    }

    /** Ajout dans le formulaire d'un bouton.<br>
        Valeur -1 implique prend la valeur prcdente.
        @param nom Le nom du bouton
        @param button Texte du bouton 
        @param xChamp coordonne du bouton (ou -1)
        @param yChamp coordonne du bouton (ou -1)
        @param width longueur du bouton (ou -1)
    */
    public void addButton(String nom,
                          String button,
                          int xChamp,
                          int yChamp,
                          int width)
    {
        if (xChamp==-1) xChamp=this.xCour;
        if (yChamp==-1) yChamp=this.yCour;
        if (width==-1)  width =this.widthButtonCour;

        this.xCour=xChamp;
        this.yCour=yChamp+this.heightText+3;
        this.widthButtonCour = width;

        
        JButton b = new JButton(button);
        b.setFont(new Font(font,Font.BOLD,tailleFonte));
        elements.put(nom,b);
        b.setBounds(xChamp,yChamp,width,this.heightText);

        b.setPreferredSize(new Dimension(width,this.heightText));
        b.addActionListener(new SubmitListener(this,nom));

        this.panelPP.add(b);
        this.panelPP.repaint();
        this.frame.repaint();
    }

    /** Ajout dans le formulaire d'un bouton.
        @param button Texte du bouton 
    */
    public void addButton(String nom,String button)
    {
        addButton(nom,button,-1,-1,-1);
    }

    /** Mthode qui retourne la valeur d'un champ.
        @param nom Le nom du champ
        @return valeur la nouvelle valeur du champ */
    public String getValeurChamp(String nom)
    {
        String ret="";
        JComponent comp = elements.get(nom);
            
        try{
            if ( comp instanceof JList )
                {
                    JList l = (JList)comp;
                    if (! l.isSelectionEmpty())
                        ret = (String)(l.getSelectedValue());
                }
            else
                {
                    JTextComponent ct = (JTextComponent)comp;
                    ret=ct.getText();
                }
        }catch(Exception ex){}
        return ret;
    }

    /** Mthode qui change la valeur d'un champ.
        @param nom Le nom du champ
        @param valeur la nouvelle valeur du champ */
    public void setValeurChamp(String nom,String valeur)
    {
        JComponent comp = elements.get(nom);
        try{
            JTextComponent ct = (JTextComponent)comp;
            ct.setText(valeur);
        }catch(Exception ex){}
    }


    /** Mthode qui change les valeurs d'une liste de scroll
        @param nom Le nom du champ
        @param value la nouvelle liste de valeur */
    public void setListData(String nom,String[] values)
    {
        try{
            JComponent comp = elements.get(nom);
            JList l = (JList)comp;
            Vector<String> v = new Vector<String>();
            if (values!=null)
                Collections.addAll(v,values);
            l.setListData(v);
        }catch(Exception ex){}
    }


    // Classe d'action des boutons du formulaire
    class SubmitListener implements ActionListener
    {
        private Formulaire form;
        private String     nomSubmit;

        public SubmitListener(Formulaire form, String nomSubmit)
        {
            this.form      = form;
            this.nomSubmit = nomSubmit;
        }

        public void actionPerformed(ActionEvent e)
        {
            try{
                if (app!=null)   // NE PAS UTILISER this.app : on est dans une inner class
                    app.submit(form,nomSubmit);
                
                if (this.nomSubmit.equals( buttonFermer))
                    {
                        frame.dispose();
                        if (synchrone) debloquer();
                    }
            }
            catch(Exception ex)
                {
                    ex.printStackTrace();
                    if (synchrone) 
                        {
                            frame.dispose();
                            debloquer();
                            exceptionForm = ex;
                        }
                }
        }
    }

    // Classe pour fermer le formulaire
    class FormulaireWindowListener extends WindowAdapter
    {
        public void windowClosing(WindowEvent e)
        {
            frame.dispose();
            if (synchrone) debloquer();
        }
    }

    /* Pour attendre l'execution du code si mmode synchrine */
    private void attendre() 
    {
        synchronized(this.verrou)
            {
                try{this.verrou.wait();}catch(Exception l_ex)
                    {System.out.println(l_ex);};
            }
    }
    private void debloquer()
    {
        synchronized(this.verrou)
            {
                try{this.verrou.notify();}catch(Exception l_ex){};
            }
    }

    // ==========================================
    /** Mthodes de saisie lmentaire d'un texte.<BR>
        Ceci remplace la classe Terminal
        @param texteInvite Texte d'invite de saisi
    */
    public static String lireString(String texteInvite)
    {
        SaisieString saisie = new SaisieString();
        Formulaire form = new Formulaire("Saisi de String",
                                         saisie,
                                         true,150,2*Formulaire.heightText);

        form.addText("String",texteInvite,true,"",0,0,50,0,100);
        form.addButton("Valider","Valider",0,Formulaire.heightText,180);
        form.setButtonFermer("Valider");
        try{
            form.afficher();
        }catch(Exception ex){
            System.out.println("Erreur de saisi dans le formulaire"); }
        
        return saisie.value;
    }

    /**
      Programme principal de test de la classe Formulaire.
      Cette mthode teste les mthodes de classe.
    */
    public static void main (String... args) throws Exception
    {
        // Affichage d'un formulaire qui calcule l'addition de deux entiers
        //
        TesterFormulaire test1 = new TesterFormulaire();
        boolean synchrone = false;
        Formulaire form = new Formulaire("TESTER",test1,synchrone,700,600);

        form.addLabel("Faire l'addition de deux entiers :",10,10,300);
        form.addText("val1","Valeur 1 :",true,"123",10,50,100,0,200);
        form.addText("val2","Valeur 2",true,"456",10,100,100,20,200);
        form.addButton("add","Additionner",10,140,100);
        String[] values = { "la belle de nuit", "la fille de l'air","le garon manqu","abcdefghijklmnopqrstuvwxyz","111","2222","3333"};
        form.addListScroll("LIST","Zone ",true,values,-1,-1,200,100);
        form.addButton("SELECTION","SELECTION",-1,-1,200);

        form.addZoneText("zone","Historique",true,"",350,30,300,500);


        form.addButton("exit","Fermer la fenetre",0,500,300);
        form.setButtonFermer("exit");
        form.afficher();
        
        // Saisie SYNCHRONE d'une chaine
        //
        String str = Formulaire.lireString("Saisir");
        System.out.println(str);


        // Un autre exemple de formulaire pour montrer les possibilits de positionnement
        //
        form = new Formulaire("TESTER",null,false,700,600);

        form.addText("Exemple","Exemple",true,"ABCDE",10,10,100,20,200);
        form.addText("Champ1","Champ1",true);  // Garde les valeurs du text prcdent et se met en dessous par dfaut.
        form.addButton("B1","B1"); // Par dfaut les boutons se mettent les uns sous les autres
        form.addButton("B2","B2");
        form.addButton("B3","B3");
        form.addButton("B4","B4",100,-1,50); //x=100 et en dessous par defaut
        form.addButton("B5","B5",300,20,50); 
        form.addText("Champ2","Champ2",false,"222"); // non editable
        form.addText("Champ3","Champ3",true,"33333");
        // En dessosu par dfaut et garde la valeur de x=100
        form.addZoneText("z1","Zone 1",true,"",-1,-1,300,100);
        form.addZoneText("z2","Zone 2",true,"",-1,-1,100,100);
        form.addText("z4","Champ4",true,"33333");
        form.afficher();

    }
}

// ================================================================

// Classe non inner-class car utilise dans une mthode statique.
// Cette classe est utilis pour saisir une chaine dans une IHM
//  et de manire synchrone
//
class SaisieString implements FormulaireInt
{
    String value;
    
    public SaisieString()
    {
        value="";
    }
    
    public void submit(Formulaire form,String nomSubmit)
    {
        if (nomSubmit.equals("Valider"))
            {
                this.value   = form.getValeurChamp("String");
            }
    }

}

class TesterFormulaire implements FormulaireInt
{
    String historique;
    
    public TesterFormulaire()
    {
        historique = "";
    }

    public void submit(Formulaire form,String nomSubmit)
    {
        if (nomSubmit.equals("add"))
            {
                try{
                    String s1 = form.getValeurChamp("val1");
                    String s2 = form.getValeurChamp("val2");
                    int v1 = Integer.parseInt(s1);
                    int v2 = Integer.parseInt(s2);
                    
                    historique = historique+String.format("%5d + %5d = %7d\n",v1,v2,v1+v2);
                }catch(Exception ex)
                    {
                        historique = historique+ex.getMessage()+"\n";
                    }
            }
        if (nomSubmit.equals("SELECTION"))
            {
                historique = historique + ">> "+ form.getValeurChamp("LIST")+"\n";
            }
        form.setValeurChamp("zone",historique);
    }
}

    
